/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.extended.behaviours._package.debug.impl;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.StringExpression;
import com.ebmwebsourcing.easyviper.core.extended.behaviours._package.debug.api.LoggerBehaviour;
import com.ebmwebsourcing.easyviper.core.extended.behaviours._package.debug.impl.BreakpointBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.extended.behaviours._package.debug.impl.EchoBehaviourImpl;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.fraclet.annotations.Component;
import org.objectweb.fractal.fraclet.annotations.Interface;
import org.objectweb.fractal.fraclet.annotations.Requires;
import org.objectweb.fractal.fraclet.types.Contingency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(provides={@Interface(name="service", signature=LoggerBehaviour.class)})
public class LoggerBehaviourImpl
extends EchoBehaviourImpl
implements LoggerBehaviour {
    private static final long serialVersionUID = 1L;
    private Logger log = Logger.getLogger(BreakpointBehaviourImpl.class.getName());
    @Requires(contingency=Contingency.OPTIONAL, name="node")
    protected Node node;
    private LoggerBehaviour.LEVEL level;

    @Override
    public LoggerBehaviour.LEVEL getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(LoggerBehaviour.LEVEL lEVEL) {
        this.level = lEVEL;
    }

    @Override
    protected void listFc(List<String> list) {
        if (this.node != null) {
            list.add("node");
        }
        super.listFc(list);
    }

    @Override
    public void severe(String string) {
        this.log.severe("[BPEL] " + Calendar.getInstance().getTime().toString() + " " + string);
    }

    @Override
    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("node")) {
            return this.node;
        }
        return super.lookupFc(string);
    }

    @Override
    public void warning(String string) {
        this.log.warning("[BPEL]  " + Calendar.getInstance().getTime().toString() + " " + string);
    }

    @Override
    public void info(String string) {
        this.log.info("[BPEL] " + Calendar.getInstance().getTime().toString() + " " + string);
    }

    @Override
    public void bindFc(String string, Object object) throws NoSuchInterfaceException {
        if (string.equals("node")) {
            this.node = (Node)object;
            return;
        }
        super.bindFc(string, object);
    }

    @Override
    public void debug(String string) {
        this.log.info("[BPEL] " + Calendar.getInstance().getTime().toString() + " " + string);
    }

    @Override
    public void unbindFc(String string) throws NoSuchInterfaceException {
        if (string.equals("node")) {
            this.node = null;
            return;
        }
        super.unbindFc(string);
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public String toString() {
        return "LoggerActivity";
    }

    @Override
    public Map<String, Object> getInitializationContext() throws CoreException {
        super.getInitializationContext();
        this.context.put("message", this.getMessage());
        this.context.put("level", this.getLevel());
        return this.context;
    }

    @Override
    public void setInitializationContext(Map<String, Object> map) throws CoreException {
        this.context.put("message", map.get("message"));
        this.context.put("level", map.get("level"));
        this.setMessage((StringExpression)map.get("message"));
        this.setLevel((LoggerBehaviour.LEVEL)((Object)map.get("level")));
    }

    @Override
    protected void executeOnInactive() throws CoreException {
        String string = (String)this.getMessage().evaluate(this.node.getExecution().getParentScope());
        if (this.level == null) {
            this.severe("Level is null !" + string);
        } else if (this.level.equals((Object)LoggerBehaviour.LEVEL.SEVERE)) {
            this.severe(string);
        } else if (this.level.equals((Object)LoggerBehaviour.LEVEL.WARNING)) {
            this.warning(string);
        } else if (this.level.equals((Object)LoggerBehaviour.LEVEL.INFO)) {
            this.info(string);
        } else if (this.level.equals((Object)LoggerBehaviour.LEVEL.DEBUG)) {
            this.debug(string);
        }
    }
}

