/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyviper.core.extended.behaviours._package.debug.util;

import java.util.List;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.extended.behaviours._package.debug.api.DebugBehaviour;

public final class DebugUtil {

	public static DebugBehaviour findDebugBehaviour(Scope process) throws CoreException {
		DebugBehaviour res = null;
		List<DebugBehaviour> debugs = process.findBehaviours(DebugBehaviour.class);
		if(debugs.size() > 1) {
			throw new CoreException("Impossible to have severals DebugBehaviour on several nodes.");
		}
		if(debugs.size() == 1) {
			res = debugs.get(0);
		}
		return res;
	}

	
}
