/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.extended.service.behaviour.impl.util.jarLoader;

import com.ebmwebsourcing.easyviper.extended.service.behaviour.impl.util.jarLoader.JarException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class JarLoader
extends URLClassLoader {
    private List<Class<?>> classList = new ArrayList();
    private Map<String, List<String>> resources = new HashMap<String, List<String>>();
    private Logger log = Logger.getLogger(JarLoader.class.getCanonicalName());

    public JarLoader(URL uRL, ClassLoader classLoader) throws JarException {
        this(uRL, JarLoader.getAllUrlsInManifest(uRL), classLoader);
    }

    private JarLoader(URL uRL, URL[] uRLArray, ClassLoader classLoader) {
        super(uRLArray, classLoader);
        this.load(uRL);
    }

    private static URL[] getAllUrlsInManifest(URL uRL) throws JarException {
        Object object;
        ArrayList<URL> arrayList = new ArrayList<URL>();
        if (uRL != null) {
            object = null;
            try {
                File file;
                Manifest manifest = null;
                try {
                    file = new File(uRL.toURI());
                }
                catch (URISyntaxException uRISyntaxException) {
                    file = new File(uRL.getPath());
                }
                object = new JarInputStream(new FileInputStream(file));
                manifest = ((JarInputStream)object).getManifest();
                if (manifest != null) {
                    Attributes attributes = manifest.getMainAttributes();
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    if (attributes != null && attributes.getValue("Class-Path") != null) {
                        StringTokenizer stringTokenizer = new StringTokenizer(attributes.getValue("Class-Path"), " ");
                        while (stringTokenizer.hasMoreElements()) {
                            arrayList2.add(file.getAbsolutePath().substring(0, file.getAbsolutePath().lastIndexOf(File.separatorChar) + 1) + stringTokenizer.nextToken());
                        }
                    }
                    arrayList2.add(0, file.toString());
                    for (String string : arrayList2) {
                        arrayList.add(0, new File(string).toURI().toURL());
                    }
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new JarException(fileNotFoundException);
            }
            catch (IOException iOException) {
                throw new JarException(iOException);
            }
            finally {
                if (object != null) {
                    try {
                        ((ZipInputStream)object).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        object = new URL[arrayList.size()];
        return arrayList.toArray((T[])object);
    }

    public List<Class<?>> getClassList() {
        return this.classList;
    }

    public Map<String, List<String>> getResources() {
        return this.resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(URL uRL) {
        ZipInputStream zipInputStream = null;
        try {
            Object object;
            File file;
            Manifest manifest = null;
            try {
                file = new File(uRL.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                file = new File(uRL.getPath());
            }
            zipInputStream = new JarInputStream(new FileInputStream(file));
            ZipFile zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                object = zipEntry.getName();
                hashtable.put(((String)object).replace("\\", "/"), (int)zipEntry.getSize());
            }
            zipFile.close();
            object = new Hashtable();
            JarEntry jarEntry = null;
            while ((jarEntry = ((JarInputStream)zipInputStream).getNextJarEntry()) != null) {
                int n;
                String string = jarEntry.getName().replace("\\", "/");
                int n2 = (Integer)hashtable.get(string);
                byte[] byArray = new byte[n2];
                int n3 = 0;
                if (manifest == null && string.equals("META-INF/MANIFEST.MF")) {
                    manifest = new Manifest();
                    while (n3 != n2) {
                        n = ((JarInputStream)zipInputStream).read(byArray, n3, n2 - n3);
                        if (n <= 0) continue;
                        n3 += n;
                    }
                    manifest.read(new ByteArrayInputStream(byArray));
                    continue;
                }
                if (!string.endsWith(".class")) {
                    this.addResources(string);
                    continue;
                }
                while (n3 != n2) {
                    n = ((JarInputStream)zipInputStream).read(byArray, n3, n2 - n3);
                    if (n <= 0) continue;
                    n3 += n;
                }
                ((Hashtable)object).put(string, byArray);
            }
            this.defineClassList((Hashtable<String, byte[]>)object);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                if (zipInputStream != null) {
                    zipInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void addResources(String string) {
        String string2;
        if (string.contains(".") && (string2 = string.substring(string.indexOf(".") + 1, string.length())).length() == 3) {
            List<String> list = this.resources.get(string2.toLowerCase());
            if (list == null) {
                list = new ArrayList<String>();
            }
            list.add(string);
            this.resources.put(string2, list);
        }
    }

    public List<Class<?>> defineClassList(Hashtable<String, byte[]> hashtable) {
        Enumeration<String> enumeration = hashtable.keys();
        Map<String, byte[]> map = new HashMap<String, byte[]>();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            byte[] byArray = hashtable.get(string);
            if (!string.endsWith(".class")) continue;
            String string2 = string.substring(0, string.indexOf(46));
            string2 = string2.replace("/", ".");
            map.put(string2, byArray);
        }
        map = this.classes2reload(map);
        for (int i = 0; map.size() > 0 && i < 100; ++i) {
            map = this.classes2reload(map);
        }
        return this.getClassList();
    }

    private Map<String, byte[]> classes2reload(Map<String, byte[]> map) {
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        Iterator<Map.Entry<String, byte[]>> iterator = map.entrySet().iterator();
        Class<?> clazz = null;
        while (iterator.hasNext()) {
            Map.Entry<String, byte[]> entry = iterator.next();
            try {
                clazz = this.defineClass(entry.getKey(), entry.getValue(), 0, entry.getValue().length);
            }
            catch (LinkageError linkageError) {
                this.log.warning("Impossible to load: " + linkageError.getMessage());
                try {
                    System.err.println("entry.getKey() = " + entry.getKey());
                    clazz = this.loadClass(entry.getKey());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    hashMap.put(entry.getKey(), entry.getValue());
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    hashMap.put(entry.getKey(), entry.getValue());
                }
            }
            if (clazz != null && !this.classList.contains(entry.getKey())) {
                this.classList.add(clazz);
            }
            clazz = null;
        }
        return hashMap;
    }

    public static Object callMethod(Class<?> clazz, Object object, String string, Object ... objectArray) throws JarException {
        Object object2 = null;
        try {
            Method method = null;
            for (int i = 0; i < clazz.getMethods().length; ++i) {
                if (!clazz.getMethods()[i].getName().equals("setMessage")) continue;
                method = clazz.getMethods()[i];
                break;
            }
            object2 = method.invoke(object, objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JarException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JarException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new JarException(invocationTargetException);
        }
        return object2;
    }

    public String toString() {
        String string = "";
        for (Class<?> clazz : this.getClassList()) {
            string = clazz.getName() + "\n";
        }
        return string;
    }
}

