/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easywsdl11.api.type;

import com.ebmwebsourcing.easybox.api.AbstractXmlObjectTestSuite;
import com.ebmwebsourcing.easybox.api.ObjectUnderTestFactory;
import com.ebmwebsourcing.easybox.api.TestData;
import com.ebmwebsourcing.easywsdl11.api.element.Port;
import com.ebmwebsourcing.easywsdl11.api.type.TService;
import java.util.Arrays;
import java.util.LinkedList;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public final class TServiceTestSuite
extends AbstractXmlObjectTestSuite {
    public static final String EXPECTED_PORTS = "expectedPorts";

    public TServiceTestSuite(String label, ObjectUnderTestFactory objectUnderTestFactory, TestData testData) {
        super(label, objectUnderTestFactory, testData);
    }

    @Test
    public void testGetPorts() {
        TService tService = (TService)this.newXmlObjectUnderTest();
        Object[] expectedPorts = (Port[])this.getTestData(EXPECTED_PORTS);
        Assert.assertArrayEquals((Object[])expectedPorts, (Object[])tService.getPorts());
    }

    @Test
    public void testGetPortByName() {
        Port[] expectedPorts;
        TService tService = (TService)this.newXmlObjectUnderTest();
        for (Port expectedPort : expectedPorts = (Port[])this.getTestData(EXPECTED_PORTS)) {
            if (expectedPort.getName() == null) continue;
            Assert.assertEquals((Object)expectedPort, (Object)tService.getPortByName(expectedPort.getName()));
        }
    }

    @Test
    public void testAddPort() {
        TService tService = (TService)this.newXmlObjectUnderTest();
        LinkedList<Port> expectedPorts = new LinkedList<Port>(Arrays.asList((Port[])this.getTestData(EXPECTED_PORTS)));
        Port newPort = (Port)this.getXmlContext().getXmlObjectFactory().create(Port.class);
        newPort.setName("newPortName");
        expectedPorts.add(newPort);
        tService.addPort(newPort);
        Assert.assertEquals(expectedPorts, Arrays.asList(tService.getPorts()));
    }

    @Test
    public void testRemovePort() {
        TService tService = (TService)this.newXmlObjectUnderTest();
        for (Port port : tService.getPorts()) {
            tService.removePort(port);
            Assert.assertFalse((boolean)Arrays.asList(tService.getPorts()).contains(port));
        }
    }

    @Test
    public void testClearPorts() {
        TService tService = (TService)this.newXmlObjectUnderTest();
        tService.clearPorts();
        Assert.assertEquals((long)0L, (long)tService.getPorts().length);
    }

    @Test
    public void testGetParentAfterAdding() {
        TService tService = (TService)this.newXmlObjectUnderTest();
        Port newPort = (Port)this.getXmlContext().getXmlObjectFactory().create(Port.class);
        tService.addPort(newPort);
        Assert.assertEquals((Object)tService, (Object)newPort.getXmlObjectParent());
    }

    @Test
    public void testGetParentAfterRemoval() {
        TService tService = (TService)this.newXmlObjectUnderTest();
        Port newPort = (Port)this.getXmlContext().getXmlObjectFactory().create(Port.class);
        tService.addPort(newPort);
        tService.removePort(newPort);
        Assert.assertNull((Object)newPort.getXmlObjectParent());
    }
}

