/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.enforcerrules;

import com.ebmwebsourcing.enforcerrules.AbstractRule;
import java.io.File;
import java.net.URI;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.Parent;
import org.apache.maven.project.MavenProject;

public class ValidParentRelativePath
extends AbstractRule {
    private static final String SCM_PREFIX_PATTERN = "scm:svn:";

    @Override
    protected void doExecute(EnforcerRuleHelper helper) throws Exception {
        MavenProject cMavenProject = (MavenProject)helper.evaluate("${project}");
        Parent parent = cMavenProject.getOriginalModel().getParent();
        if (parent == null) {
            return;
        }
        String parentRelativePath = parent.getRelativePath();
        MavenProject parentMavenProject = cMavenProject.getParent();
        String parentScmConnection = parentMavenProject.getScm().getConnection();
        String cScmConnection = cMavenProject.getScm().getConnection();
        String cSvnUrl = cScmConnection.replaceFirst(SCM_PREFIX_PATTERN, "");
        String parentSvnUrl = parentScmConnection.replaceFirst(SCM_PREFIX_PATTERN, "");
        String curProjectPath = new URI(cSvnUrl).getPath();
        String parentProjectPath = new URI(parentSvnUrl).getPath();
        String expectedParentProjectPath = new File(curProjectPath + "/" + parentRelativePath).getParentFile().getCanonicalPath();
        if (!expectedParentProjectPath.equals(parentProjectPath)) {
            StringBuilder builder = new StringBuilder("The relative path of the parent is wrong:\n");
            builder.append("\tParent Relative Path: [" + parentRelativePath + "]\n");
            builder.append("\tArtifact: [" + cMavenProject.getId() + "]\n");
            builder.append("\tParent artifact: [" + parentMavenProject.getId() + "]\n");
            builder.append("\tExpected parent project path: [" + expectedParentProjectPath + "]\n");
            builder.append("\tResolved parent project path: [" + parentProjectPath + "]\n");
            throw new EnforcerRuleException(builder.toString());
        }
    }
}

