/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.enforcerrules;

import com.ebmwebsourcing.enforcerrules.AbstractRule;
import java.util.regex.Pattern;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.Scm;
import org.apache.maven.project.MavenProject;

public class VersionNumberConvention
extends AbstractRule {
    private static final Pattern majorTrunkVersionNumberPattern = Pattern.compile("0-SNAPSHOT|([0-9][0-9]*\\.[0-9]+(\\.0|)(-SNAPSHOT|))");
    private static final Pattern majorBranchesVersionNumberPattern = Pattern.compile("[1-9][0-9]*\\.[0-9]+(\\.[1-9])(-SNAPSHOT)?");

    @Override
    protected void doExecute(EnforcerRuleHelper helper) throws Exception {
        String mavenProjectVersion;
        MavenProject mavenProject = (MavenProject)helper.evaluate("${project}");
        Scm scm = mavenProject.getScm();
        if (scm == null || scm.getConnection() == null) {
            throw new EnforcerRuleException(String.format("Project %s:%s has no scm connection defined!", mavenProject.getArtifactId(), mavenProject.getVersion()));
        }
        String svnUrlStr = mavenProject.getScm().getConnection().replaceAll("scm:svn:", "");
        if (svnUrlStr.contains("trunk")) {
            String mavenProjectVersion2 = mavenProject.getVersion();
            if (!majorTrunkVersionNumberPattern.matcher(mavenProjectVersion2).matches()) {
                throw new EnforcerRuleException(String.format("Project version %s does not match the trunk format 0-SNAPSHOT or X.Y[.0][-SNAPSHOT] where X is included between 0 and n and Y between 0 and n", mavenProjectVersion2));
            }
        } else if (svnUrlStr.contains("branches") && !majorBranchesVersionNumberPattern.matcher(mavenProjectVersion = mavenProject.getVersion()).matches()) {
            throw new EnforcerRuleException(String.format("Project version %s does not match the branches format X.Y.Z[-SNAPSHOT] where X is included between 1 and n, Y between 0 and n and Z between 1 and n", mavenProjectVersion));
        }
    }
}

