
package com.ebmwebsourcing.enforcerrules;

enum SvnSection {

    UNKNOWN("unknown"), STABLE("stable"), COOKING("cooking"), PROD("prod"), EXPERIMENTAL(
            "experimental"), RESEARCH("research");

    private String sectionName;

    SvnSection(String sectionName) {
        this.sectionName = sectionName;
    }

    public static SvnSection fromString(String sectionName) {
        if (sectionName == null)
            return UNKNOWN;
        if (sectionName.equals("stable")) {
            return STABLE;
        } else if (sectionName.equals("cooking")) {
            return COOKING;
        } else if (sectionName.equals("prod")) {
            return PROD;
        } else if (sectionName.equals("experimental")) {
            return EXPERIMENTAL;
        } else {
            return UNKNOWN;
        }
    }

    public String toString() {
        return this.sectionName;
    }

    boolean canDependOn(SvnSection other) {
        return this.ordinal() >= other.ordinal();
    }

}
