
package com.ebmwebsourcing.enforcerrules;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

final class VersionUtil {

    static String getLatestSnapshotVersion(List<String> versions) throws ComponentLookupException,
            ExpressionEvaluationException, ArtifactMetadataRetrievalException, IOException {
        String latestSnapshotVersion = "";
        Iterator<String> itVersion = versions.iterator();
        while (itVersion.hasNext()) {
            String version = itVersion.next();
            if (!version.contains("-SNAPSHOT"))
                continue;
            version = version.replaceAll("-SNAPSHOT", "");
            if (version.compareTo(latestSnapshotVersion) > 0) {
                latestSnapshotVersion = version;
            }
        }
        return latestSnapshotVersion.isEmpty() ? null : latestSnapshotVersion + "-SNAPSHOT";
    }

}
