
package com.ebmwebsourcing.enforcerrules;

import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;

public class ProjectNameEqualsArtifactId extends AbstractRule {

    public void doExecute(EnforcerRuleHelper helper) throws Exception {
        String projectName = (String) helper.evaluate("${project.name}");
        String artifactId = (String) helper.evaluate("${project.artifactId}");

        if (!projectName.equals(artifactId)) {
            throw new EnforcerRuleException("Project artifact id must be equal to project name.");
        }

    }

}
