/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.enforcerrules;

import com.ebmwebsourcing.enforcerrules.AbstractRule;
import com.ebmwebsourcing.enforcerrules.SvnUtil;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.project.MavenProject;

public class ScmConnectionMustMatchSvnEntriesIfAny
extends AbstractRule {
    @Override
    public void doExecute(EnforcerRuleHelper helper) throws Exception {
        MavenProject mavenProject = (MavenProject)helper.evaluate("${project}");
        String expectedScmConnection = SvnUtil.grepScmConnectionFromSvnEntries(mavenProject);
        if (expectedScmConnection == null) {
            helper.getLog().info((CharSequence)".svn/entries file is not present or not readable ; rule ignored.");
            return;
        }
        String actualScmConnection = String.valueOf(helper.evaluate("${project.scm.connection}"));
        if (!expectedScmConnection.equals(actualScmConnection)) {
            throw new EnforcerRuleException(String.format("Wrong SCM connection '%s' ; '%s' was expected.", actualScmConnection, expectedScmConnection));
        }
    }
}

