
package com.ebmwebsourcing.enforcerrules;

import java.util.List;

import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.project.MavenProject;

public class NoInternalDependencyInDependencyManagement extends AbstractRule {

    @SuppressWarnings("unchecked")
    @Override
    protected void doExecute(EnforcerRuleHelper helper) throws Exception {
        MavenProject mavenProject = (MavenProject) helper.evaluate("${project}");
        DependencyManagement dependencyManagement = mavenProject.getDependencyManagement();

        List<Dependency> dependencies = dependencyManagement.getDependencies();
        for (Dependency dependency : dependencies) {
            String groupId = dependency.getGroupId();
            String artifactId = dependency.getArtifactId();
            boolean isPetalsLinkProject = isPetalsLinkProject(groupId, artifactId);
            if (isPetalsLinkProject) {
                throw new EnforcerRuleException(String.format(
                        "The dependency %s:%s is not allowed in the dependencyManagement section.",
                        groupId, artifactId));
            }
        }
    }

}
