/**
 *
 */

package com.ebmwebsourcing.enforcerrules;

import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.DistributionManagement;

/**
 * @author ofabre
 *
 */
public class OnlyInternalSnapshotRepoWithoutTimestampIsAllowedAsDistribRepo extends AbstractRule {

    @Override
    protected void doExecute(EnforcerRuleHelper helper) throws Exception {

        DistributionManagement distribMan = (DistributionManagement) helper
                .evaluate("${project.distributionManagement}");
        if (distribMan != null) {
            DeploymentRepository snapshotRepository = distribMan.getSnapshotRepository();
            if (snapshotRepository != null) {
                if (!PETALSLINK_SNAPSHOT_REPO.equals(snapshotRepository.getUrl())) {
                    throw new EnforcerRuleException(
						    "Project distribution snapshot repository must be our internal snapshot repository: "
						    + PETALSLINK_SNAPSHOT_REPO);
                }
                if (snapshotRepository.isUniqueVersion()) {
                    throw new EnforcerRuleException(String.format(
                                                                  "Timestamps are forbidden for deployed snapshots on repository '%s'.",
                                                                  snapshotRepository.getId()));
                }
            } else {
                throw new EnforcerRuleException("Project must define a snapshot repository.");
            }
        }

    }

}
