
package com.ebmwebsourcing.enforcerrules;

import java.util.ArrayList;
import java.util.List;

import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;

public class ScmConnectionMustEndLikeGroupId extends AbstractRule {

    public void doExecute(EnforcerRuleHelper helper) throws Exception {
        List<String> prefixes = new ArrayList<String>();
    	prefixes.add("com.ebmwebsourcing.");
    	prefixes.add("com.petalslink.");
    	prefixes.add("org.petalslink.");
    	
    	String actualScmConnection = String.valueOf(helper.evaluate("${project.scm.connection}"));

        String expectedScmConnectionTail = String.valueOf(helper.evaluate("${project.groupId}"));

        for(String prefix : prefixes){
        	if(expectedScmConnectionTail.startsWith(prefix)){
        		expectedScmConnectionTail = expectedScmConnectionTail.replaceAll(prefix,"");
        		break;
        	}
        }
        
        expectedScmConnectionTail = expectedScmConnectionTail.replaceAll("\\.", "/");
        expectedScmConnectionTail += "/" + String.valueOf(helper.evaluate("${project.name}"));
        
        if (!actualScmConnection.endsWith(expectedScmConnectionTail)) {
            throw new EnforcerRuleException(String.format(
                    "SCM connection does not follow convention ; '%s' should end with '%s'.",
                    actualScmConnection, expectedScmConnectionTail));
        }
    }

}
