/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.enforcerrules;

import com.ebmwebsourcing.enforcerrules.SvnSection;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

abstract class AbstractRule
implements EnforcerRule {
    private static final Pattern svnSectionPattern = Pattern.compile("svnroot/trunk/(dev|research)/([^/]*)/");
    public static final String PETALSLINK_SNAPSHOT_REPO = "http://maven.petalslink.com/public-snapshot";
    public static final String PETALSLINK_ARTIFACTORY_SNAPSHOT_REPO = "http://m2proxy:8081/artifactory/libs-snapshot-local";

    AbstractRule() {
    }

    protected final SvnSection guessMavenProjectSvnSection(MavenProject mavenProject) {
        if (mavenProject.getScm() == null) {
            return SvnSection.UNKNOWN;
        }
        if (mavenProject.getScm().getConnection() == null) {
            return SvnSection.UNKNOWN;
        }
        Matcher matcher = svnSectionPattern.matcher(mavenProject.getScm().getConnection());
        if (matcher.find()) {
            if (matcher.group(1).equals("dev")) {
                String guessedSvnSection = matcher.group(2);
                return SvnSection.fromString(guessedSvnSection);
            }
            return SvnSection.RESEARCH;
        }
        return SvnSection.UNKNOWN;
    }

    protected final boolean isPetalsLinkProject(EnforcerRuleHelper helper, MavenProject project) {
        String groupId = project.getGroupId();
        String artifactId = project.getArtifactId();
        return this.isPetalsLinkProject(groupId, artifactId);
    }

    protected final boolean isPetalsLinkProject(String groupId, String artifactId) {
        if ("petals-jaas".equals(artifactId)) {
            return false;
        }
        if (groupId.startsWith("com.ebmwebsourcing")) {
            return true;
        }
        if (groupId.startsWith("org.ow2.dragon")) {
            return true;
        }
        if (groupId.startsWith("org.ow2.easywsdl")) {
            return true;
        }
        return groupId.startsWith("org.ow2.petals");
    }

    protected static DOMSource parseAsDOMSource(InputStream is) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        try {
            Document doc = dbf.newDocumentBuilder().parse(is);
            DOMSource domSource = new DOMSource(doc);
            return domSource;
        }
        catch (SAXException se) {
            throw new RuntimeException(se);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException(pce);
        }
    }

    protected final MavenProject findMavenProjectForDependency(EnforcerRuleHelper helper, MavenProject parentProject, Dependency dependency) throws EnforcerRuleException, ExpressionEvaluationException, ComponentLookupException {
        ArtifactRepository localRepository = (ArtifactRepository)helper.evaluate("${localRepository}");
        ArtifactFactory artifactFactory = (ArtifactFactory)helper.getComponent(ArtifactFactory.class);
        Artifact pomArtifact = artifactFactory.createArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getClassifier(), dependency.getType());
        MavenProjectBuilder mpb = (MavenProjectBuilder)helper.getComponent(MavenProjectBuilder.class);
        try {
            MavenProject dependencyMavenProject = mpb.buildFromRepository(pomArtifact, parentProject.getRemoteArtifactRepositories(), localRepository);
            return dependencyMavenProject;
        }
        catch (ProjectBuildingException e) {
            throw new EnforcerRuleException("Cannot create dependency MavenProject.", (Exception)((Object)e));
        }
    }

    protected abstract void doExecute(EnforcerRuleHelper var1) throws Exception;

    public final void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        Log log = helper.getLog();
        try {
            log.info((CharSequence)String.format("Checking enforcer rule %s.", this.getClass().getSimpleName()));
            this.doExecute(helper);
        }
        catch (EnforcerRuleException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new EnforcerRuleException("Unexpected problem." + e.getLocalizedMessage(), e);
        }
    }

    public String getCacheId() {
        return "";
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isResultValid(EnforcerRule arg0) {
        return false;
    }
}

