/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.enforcerrules;

import com.ebmwebsourcing.enforcerrules.AbstractRule;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Scm;
import org.apache.maven.project.MavenProject;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.w3c.dom.Node;

public class InternalSnapshotDependenciesMustBeAlignedOnTrunk
extends AbstractRule {
    private static final Map<MavenProject, String> trunkSnapshotVersionsMap = new HashMap<MavenProject, String>();
    private static final File svnConfigDir;

    @Override
    protected void doExecute(EnforcerRuleHelper helper) throws Exception {
        MavenProject mavenProject = (MavenProject)helper.evaluate("${project}");
        if (!mavenProject.getVersion().endsWith("SNAPSHOT")) {
            return;
        }
        MavenProject parentMavenProject = mavenProject.getParent();
        if (parentMavenProject != null) {
            this.checkSnapshotVersion(helper, mavenProject.getParent());
        }
        for (Object o : mavenProject.getDependencies()) {
            Dependency dep = (Dependency)o;
            MavenProject dependencyMavenProject = this.findMavenProjectForDependency(helper, mavenProject, dep);
            this.checkSnapshotVersion(helper, dependencyMavenProject);
        }
    }

    private final void checkSnapshotVersion(EnforcerRuleHelper helper, MavenProject project) throws Exception {
        if (!this.isPetalsLinkProject(helper, project)) {
            return;
        }
        String trunkSnapshotVersion = this.getCurrentSnapshotVersionFromTrunk(helper, project);
        if (trunkSnapshotVersion == null) {
            throw new EnforcerRuleException("Cannot guess trunk SNAPSHOT version");
        }
        if (!project.getVersion().equals(trunkSnapshotVersion)) {
            throw new EnforcerRuleException(String.format("Project depends on %s %s but trunk SNAPSHOT version is %s.", project.getArtifactId(), project.getVersion(), trunkSnapshotVersion));
        }
    }

    private final String getCurrentSnapshotVersionFromTrunk(EnforcerRuleHelper helper, MavenProject project) throws Exception {
        File checkedOutPom;
        if (trunkSnapshotVersionsMap.containsKey(project)) {
            return trunkSnapshotVersionsMap.get(project);
        }
        DefaultSVNOptions options = SVNWCUtil.createDefaultOptions((boolean)true);
        Scm scm = project.getScm();
        if (scm == null || scm.getConnection() == null) {
            throw new EnforcerRuleException(String.format("Project %s:%s has no scm connection defined!", project.getArtifactId(), project.getVersion()));
        }
        String svnUrlStr = project.getScm().getConnection().replaceAll("scm:svn:", "");
        if (!svnUrlStr.contains("trunk")) {
            throw new EnforcerRuleException(String.format("Project depends on %s %s but its scm is not trunk!", project.getArtifactId(), project.getVersion()));
        }
        SVNURL svnUrl = SVNURL.parseURIEncoded((String)svnUrlStr);
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        File checkoutTempDir = new File(tempDir, project.getGroupId() + "_" + project.getArtifactId());
        svnConfigDir.mkdir();
        if (!svnConfigDir.exists()) {
            throw new EnforcerRuleException("SVNKit temporary config dir does not exist or cannot be created.");
        }
        String username = System.getProperty("petalslink.scm.username");
        String password = System.getProperty("petalslink.scm.password");
        if (username == null) {
            username = "anonymous";
        }
        if (password == null) {
            password = "anonymous";
        }
        helper.getLog().info((CharSequence)String.format("Using '%s'/'%s' as subversion username/password.", username, password));
        DefaultSVNAuthenticationManager authManager = new DefaultSVNAuthenticationManager(svnConfigDir, true, username, password);
        SVNClientManager svnClientManager = SVNClientManager.newInstance((ISVNOptions)options);
        if (svnUrlStr.startsWith("https")) {
            svnClientManager.setAuthenticationManager((ISVNAuthenticationManager)authManager);
        }
        SVNUpdateClient svnUpdateClient = svnClientManager.getUpdateClient();
        int TIMEOUT_RETRYING = 10;
        for (int i = 0; i < 10; ++i) {
            try {
                svnUpdateClient.doExport(svnUrl, checkoutTempDir, SVNRevision.UNDEFINED, SVNRevision.HEAD, "\n", true, SVNDepth.FILES);
                break;
            }
            catch (SVNException e) {
                if (e.getCause() == null || !e.getCause().getClass().equals(SocketTimeoutException.class)) {
                    helper.getLog().warn((CharSequence)String.format("Cannot export SVN url '%s' ; should probably be fixed in %s:%s POM", svnUrlStr, project.getGroupId(), project.getArtifactId()), (Throwable)e);
                    return null;
                }
                if (i == 9) {
                    helper.getLog().warn((CharSequence)String.format("Cannot contact the following svn url: '%s', in order to perform export", svnUrlStr, project.getGroupId(), project.getArtifactId()), (Throwable)e);
                    return null;
                }
                helper.getLog().warn((CharSequence)String.format("Timeout occured, retry svn export for: '%s'", svnUrl));
                continue;
            }
        }
        if (!(checkedOutPom = new File(checkoutTempDir, "pom.xml")).exists()) {
            throw new EnforcerRuleException(String.format("SVN url '%s' does not contain any POM file.", svnUrlStr));
        }
        String version = this.findVersionInCheckedOutPom(helper, checkedOutPom);
        if (version != null) {
            trunkSnapshotVersionsMap.put(project, version);
        }
        return version;
    }

    private final String findVersionInCheckedOutPom(EnforcerRuleHelper helper, File checkedOutPom) throws Exception {
        FileInputStream is = null;
        try {
            String version;
            is = new FileInputStream(checkedOutPom);
            DOMSource pomDom = InternalSnapshotDependenciesMustBeAlignedOnTrunk.parseAsDOMSource(is);
            XPathFactory xpathFactory = XPathFactory.newInstance();
            XPath xpath = xpathFactory.newXPath();
            xpath.setNamespaceContext(new MavenNamespaceContext());
            String xpathExpr = "/mvn:project/mvn:version/text()";
            Node node = (Node)xpath.evaluate(xpathExpr, pomDom.getNode(), XPathConstants.NODE);
            if (node == null) {
                throw new EnforcerRuleException(String.format("Cannot resolve xpath '%s' on POM file '%s'.", xpathExpr, checkedOutPom.getAbsolutePath()));
            }
            String string = version = node.getNodeValue();
            return string;
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
        }
    }

    static {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        svnConfigDir = new File(tempDir, "enforcer.svnkit");
        DAVRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
    }

    private static final class MavenNamespaceContext
    implements NamespaceContext {
        private MavenNamespaceContext() {
        }

        @Override
        public String getNamespaceURI(String prefix) {
            if ("mvn".equals(prefix)) {
                return "http://maven.apache.org/POM/4.0.0";
            }
            return null;
        }

        @Override
        public String getPrefix(String namespaceURI) {
            if ("http://maven.apache.org/POM/4.0.0".equals(namespaceURI)) {
                return "mvn";
            }
            return null;
        }

        public Iterator<?> getPrefixes(String namespaceURI) {
            if ("http://maven.apache.org/POM/4.0.0".equals(namespaceURI)) {
                return Collections.singletonList("mvn").iterator();
            }
            return null;
        }
    }
}

