
package com.ebmwebsourcing.enforcerrules;

import java.util.List;

import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.project.MavenProject;

public class ExternalDependencyVersionsMustBeDefinedInDependencyManagement extends AbstractRule {

    @SuppressWarnings("unchecked")
    @Override
    protected void doExecute(EnforcerRuleHelper helper) throws Exception {
        MavenProject mavenProject = (MavenProject) helper.evaluate("${project}");

        if (!isJbiSharedLibraryProject(mavenProject)) {
            Model model = mavenProject.getOriginalModel();
            List<Dependency> dependencies = model.getDependencies();

            for (Dependency dependency : dependencies) {
                String groupId = dependency.getGroupId();
                String artifactId = dependency.getArtifactId();
                String version = dependency.getVersion();
                String type = dependency.getType();
                boolean isPetalsLinkProject = isPetalsLinkProject(groupId, artifactId);
                if (!isPetalsLinkProject && version != null && !type.equals("mar")) {
                    throw new EnforcerRuleException(
                            String.format(
                                    "The dependency version %s of the external project %s:%s must be defined in a dependencyManagement section.",
                                    version, groupId, artifactId));
                }
            }
        }
    }

}
