package com.ebmwebsourcing.enforcerrules;

import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class NoDependencyManagementExceptTheEbmWebsourcingOne extends AbstractRule {

    private boolean mustFail;
    
    public NoDependencyManagementExceptTheEbmWebsourcingOne() {
        this.mustFail = true;
    }
    
    @Override
    protected void doExecute(EnforcerRuleHelper helper) throws Exception {
        MavenProject mavenProject = (MavenProject) helper.evaluate("${project}");

        if (!isJbiSharedLibraryProject(mavenProject) && !isEbmWebsourcingProject(mavenProject)) {
            Model model = mavenProject.getOriginalModel();
            DependencyManagement dependencyManagement = model.getDependencyManagement();

            if(dependencyManagement != null) {
                    String message =  "Only the dependencyManagement section of the global parent project is allowed."; 
                    if(mustFail == true) {
                        throw new EnforcerRuleException(
                                message);
                    } else {
                        Log log = helper.getLog();
                        log.warn(message);
                    }
            }
        }
    }
}
