
package com.ebmwebsourcing.enforcerrules;

import java.io.File;
import java.net.URI;

import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.Parent;
import org.apache.maven.project.MavenProject;

/**
 * Check the value of the relativePath element in the parent element.
 * 
 * @author "Mathieu CARROLLE - mathieu.carrolle@petalslink.com"
 * 
 */
public class ValidParentRelativePath extends AbstractRule {

    private static final String SCM_PREFIX_PATTERN = "scm:svn:";

    @Override
    protected void doExecute(EnforcerRuleHelper helper) throws Exception {
        MavenProject cMavenProject = (MavenProject) helper.evaluate("${project}");
        Parent parent = cMavenProject.getOriginalModel().getParent();
        if (parent == null) {
            return;
        }

        String parentRelativePath = parent.getRelativePath();
        MavenProject parentMavenProject = cMavenProject.getParent();

        String parentScmConnection = parentMavenProject.getScm().getConnection();
        String cScmConnection = cMavenProject.getScm().getConnection();

        String cSvnUrl = cScmConnection.replaceFirst(SCM_PREFIX_PATTERN, "");
        String parentSvnUrl = parentScmConnection.replaceFirst(SCM_PREFIX_PATTERN, "");

        // Get the raw path of the URI
        String curProjectPath = new URI(cSvnUrl).getPath();
        String parentProjectPath = new URI(parentSvnUrl).getPath();

        String expectedParentProjectPath = new File(curProjectPath + File.separator
                + parentRelativePath).getParentFile().getCanonicalPath();

        if (!expectedParentProjectPath.equals(parentProjectPath)) {
            StringBuilder builder = new StringBuilder(
                    "The relative path of the parent pom.xml file is wrong:\n");
            builder.append("\tParent Relative Path: [" + parentRelativePath + "]\n");
            builder.append("\tArtifact: [" + cMavenProject.getId() + "]\n");
            builder.append("\tParent artifact: [" + parentMavenProject.getId() + "]");
            throw new EnforcerRuleException(builder.toString());
        }
    }
}
