/**
 * Raphael Diagram - A crossbrowser SVG/VML library creating diagrams - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.gwt.raphael.client.diagram.event;

import java.util.ArrayList;

import com.ebmwebsourcing.gwt.jquery.client.ui.handler.adapter.DropHandlerAdapter;
import com.ebmwebsourcing.gwt.raphael.client.diagram.DiagramPanel;
import com.ebmwebsourcing.gwt.raphael.client.diagram.element.DiagramElement;
import com.google.gwt.user.client.Event;
import com.j4g.client.api.F;

/**
 * 
 * @author nfleury
 *
 */
public class DiagramElementDropListenerBinder {

	
	private DiagramElement diagramElement;
	private ArrayList<DiagramElementDropListener> dropListeners;

	public DiagramElementDropListenerBinder(DiagramElement element) {
		this.diagramElement = element;
		
		
		this.dropListeners = diagramElement.getDropListeners();
		///////////////////////
		//Bind JUI listener to diagram Listener
		////////////////////////////
		DropHandlerAdapter dropableHandler = new DropHandlerAdapter(){
			
			@Override
			public F activate() {
				
				F f = new F(){

					public void f(Event event) {
							
						for(DiagramElementDropListener dropListener: dropListeners){
								
								dropListener.onActivate(diagramElement);
							
							
						}
						
					}
					
				};
				
				
				return f;
				
			}
			
			@Override
			public F deactivate() {

				F f = new F(){

					public void f(Event event) {
						
						for(DiagramElementDropListener dropListener: dropListeners){
							
							dropListener.onDeactivate(diagramElement);
						
						
						}
						
					}
					
				};
				
				
				return f;
				
				
			}
			
			@Override
			public F drop() {

				F f = new F(){

					public void f(Event event) {
						
						
						for(DiagramElementDropListener dropListener: dropListeners){
							
							dropListener.onDrop(diagramElement,(DiagramElement)DiagramPanel.draggedElement);
						
						
						}
						
					}
					
				};
				
				
				return f;
				
			}
			
			@Override
			public F out() {

				F f = new F(){

					public void f(Event event) {

						for(DiagramElementDropListener dropListener: dropListeners){
							
							
							dropListener.onOut(diagramElement,(DiagramElement)DiagramPanel.draggedElement);
						
						
						}
						
						
						
					}
					
				};
				
				
				return f;
				
			}
			
			@Override
			public F over() {

				F f = new F(){

					public void f(Event event) {

						for(DiagramElementDropListener dropListener: dropListeners){

							dropListener.onOver(diagramElement,(DiagramElement)DiagramPanel.draggedElement);
						
						
						}
						
					}
					
				};
				
				
				return f;
				
				
			}
			
			
			
			
		};
		
		
		
		
		diagramElement.getJqueryObject().droppable(dropableHandler);
		
		
	}
	
}
