/**
 * Raphael for GWT - A crossbrowser SVG/VML library for GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.gwt.raphael.client.core;

import com.google.gwt.core.client.JavaScriptObject;

public class Circle extends SVGElement {
	
	
	private int radius;

	/**
	 * 
	 * @param id
	 * @param x
	 * @param y
	 * @param r
	 */
	public Circle(String id,int x, int y, int r){
		super(id, x, y);
		
		this.radius = r;
		
		width 	= r*2;
		height 	= r*2;
		
	}
	
	public int getRadius() {
		return radius;
	}

	
	@Override
	protected JavaScriptObject addConcreteJavascriptElementToCanvas()  {
		return this.addCircleToCanvas(this.getCanvas().getJsRef(),this.getX(),this.getY(),this.getRadius());
	}
	
	
	protected native JavaScriptObject addCircleToCanvas(JavaScriptObject jsObj, int x, int y,int r)/*-{
		var circle = jsObj.circle(x,y,r);
		return circle;
	}-*/;

	
	@Override
	public void setWidth(int width) {
		
		this.radius = width / 2;
		
		super.setWidth(width);
	}
	
	
	@Override
	public void setHeight(int height) {
		
		this.radius = height / 2;
		
		super.setHeight(height);
	}
	

	@Override
	protected native void setJSHeight(JavaScriptObject jsObj, int height) /*-{
		var h = (height/2);
		jsObj.attr("r",h);
	}-*/;

	@Override
	protected native void setJSWidth(JavaScriptObject jsObj, int width) /*-{
		var w = (width/2); 
		jsObj.attr("r",w);
	}-*/;

	@Override
	protected native void setJSX(JavaScriptObject jsObj, int x) /*-{
		jsObj.attr("cx",x);
	}-*/;

	@Override
	protected native void setJSY(JavaScriptObject jsObj, int y) /*-{
		jsObj.attr("cy",y);
	}-*/;

	

}
