/**
 * Raphael for GWT - A crossbrowser SVG/VML library for GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.gwt.raphael.client.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;

import com.google.gwt.core.client.JavaScriptObject;


public class Group extends SVGElement {

	private HashMap<ChildData,SVGElement> children;
	
	public Group(String id) {
		super(id);
		
		this.children = new HashMap<ChildData, SVGElement>();
	}

	/**
	 * Adds a child to current group
	 * @param element
	 */
	public void addChild(SVGElement element){
		
		ChildData cdata = new ChildData(element,0,0);
		
		this.children.put(cdata, element);
	}
	
	public void addChild(SVGElement element,int relativeX, int relativeY){
		
		ChildData cdata = new ChildData(element,relativeX,relativeY);
		
		this.children.put(cdata, element);
	}
	
	
	public Collection<SVGElement> getChildren(){
		return this.children.values();
	}
	
	
	private Collection<ChildData> getChildrenDatas(){
		return this.children.keySet();
	}
	
	
	public SVGElement getChildById(String id){
		return this.children.get(id);
	}
	
	@Override
	protected void addJsElementToCanvas() {
		
		//add all child to canvas
		for(SVGElement element:this.getChildren()){
			this.getCanvas().addElement(element);
		}
		
		
	}
	


	@Override
	public void setX(int x) {
			
		for(ChildData c : this.getChildrenDatas()){
			
			int newX = x + c.getRelativeX();
			c.getChild().setX(newX);
			
		}

	}

	@Override
	public void setY(int y) {

		for(ChildData c : this.getChildrenDatas()){
			
			int newY = y + c.getRelativeY();
			c.getChild().setY(newY);
			
		}

	}

	
	
	private class ChildData{
		
		private SVGElement child;
		
		private int relativeX;//relative in respect to parent
		private int relativeY;

		
		/**
		 * Store some child data
		 * 
		 * @param relativeX relative X in respect to current group
		 * @param relativeY relative Y in respect to current group
		 */
		public ChildData(SVGElement element,int relativeX, int relativeY) {
			
			this.child 		= element;
			
			this.relativeX 	= relativeX;
			this.relativeY 	= relativeY;
			

			
		}
		
		public int getRelativeX() {
			return relativeX;
		}
		
		public int getRelativeY() {
			return relativeY;
		}
		
		
		public SVGElement getChild() {
			return child;
		}
		
		@Override
		public boolean equals(Object obj) {
			
			ChildData c = (ChildData) obj;
			
			if (c.getChild().getId().equals(this.getChild().getId())){
				
				return true;
				
			}
			
			return false;
		}
		
		
		@Override
		public int hashCode() {
			return this.getChild().getId().hashCode();
		}
		
	}



	@Override
	protected void setJSHeight(JavaScriptObject jsObj, int x) {
		// TODO Auto-generated method stub
		
	}

	@Override
	protected void setJSWidth(JavaScriptObject jsObj, int x) {
		// TODO Auto-generated method stub
		
	}

	@Override
	protected void setJSX(JavaScriptObject jsObj, int x) {
		// TODO Auto-generated method stub
		
	}

	@Override
	protected void setJSY(JavaScriptObject jsObj, int y) {
		// TODO Auto-generated method stub
		
	}

	@Override
	protected JavaScriptObject addConcreteJavascriptElementToCanvas() {
		return null;
	}
	
	
}
