/**
 * Raphael for GWT - A crossbrowser SVG/VML library for GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.gwt.raphael.client.core;

import com.google.gwt.core.client.JavaScriptObject;

public class Path extends SVGElement {

	private String pathString;
	
	
	/**
	 * TODO: Width and height in constructor
	 * @param id
	 * @param pathString
	 * @param currentXPosition
	 * @param currentYPosition
	 */
	public Path(String id, String pathString,int currentXPosition,int currentYPosition) {
		
		super(id, currentXPosition, currentYPosition);
		
		this.pathString = pathString;
		
		
	}

	
	
	@Override
	protected JavaScriptObject addConcreteJavascriptElementToCanvas() {
		return this.addPathToCanvas(this.getCanvas().getJsRef(), pathString,this.getX(),this.getY());

	}


	@Override
	protected void addJsElementToCanvas() {
		super.addJsElementToCanvas();
		
		setWidth((int)getJsniImpl().getWidth());
		setHeight((int)getJsniImpl().getHeight());
		
	}
	
	
	
	@Override
	public void setX(int x) {

		//delta for translation
		int newX = x- this.getX(); 
		
		if (this.isLoaded()) this.setJSX(getJsref(), newX);
		
		this.x = x;

	}
	
	
	@Override
	public void setY(int y) {
		
		//delta for translation
		int newY = y- this.getY(); 
		
		if (this.isLoaded()) this.setJSY(getJsref(), newY);
		
		this.y = y;
	}
	
	protected native void setJSX(JavaScriptObject jsObj,int dx)/*-{
		jsObj.translate(dx,0);
	}-*/;

	
	protected native void setJSY(JavaScriptObject jsObj,int dy)/*-{
		jsObj.translate(0,dy);
	}-*/;
	
	
	
	protected native JavaScriptObject addPathToCanvas(JavaScriptObject jsObj, String pathString,int x,int y)/*-{
	
		var path = jsObj.path(pathString); 
		
		path.translate(x,y);
		
	return path; 
	
	}-*/;

	


	@Override
	protected void setJSHeight(JavaScriptObject jsObj, int x) {
		// TODO Auto-generated method stub
		
	}



	@Override
	protected void setJSWidth(JavaScriptObject jsObj, int x) {
		// TODO Auto-generated method stub
		
	}




	
	

}
