/**
 * Raphael for GWT - A crossbrowser SVG/VML library for GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.gwt.raphael.client.core;

import java.util.ArrayList;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Widget;

public class Raphael extends Widget{
	
	private ArrayList<SVGElement> svgElements;
	
	private JavaScriptObject jsRef;

	private AbsolutePanel htmlCanvas;

	
	public Raphael(int x, int y, int width,int height){
		 
		 this.jsRef 		= this.raphael(x, y, width, height);
		 
		 this.svgElements 	= new ArrayList<SVGElement>();
	
	}
	
	public Raphael(AbsolutePanel ap,int width,int height){
		
		this.htmlCanvas 	= ap;
		
		this.jsRef 			= this.raphael(ap.getElement(), width, height);
		
		this.svgElements 	= new ArrayList<SVGElement>();

	}
	
	public Raphael (Element e, int width, int height){
		this.jsRef = raphael(e, width, height);
		svgElements = new ArrayList<SVGElement>();

	}
	
	
	public AbsolutePanel getHtmlCanvas() {
		return htmlCanvas;
	}
	
	private native JavaScriptObject raphael(int x, int y, int width,int height)/*-{
       return $wnd.Raphael(x,y,width,height);
    }-*/;
	
	private native JavaScriptObject raphael(Element element, int width,int height)/*-{
    	return $wnd.Raphael(element,width,height);
 	}-*/;
	
	
	public native void setSize(int width, int height)/*-{
		this.@com.ebmwebsourcing.gwt.raphael.client.core.Raphael::getJsRef()().setSize(width, height);
	}-*/;
	
	
	/*private native void testEvent()/*-{
		var rect = this.@com.ebmwebsourcing.gwt.raphael.client.core.Raphael::getJsRef()().rect(50,50,20,20);
		rect.mouseover(function (event){$wnd.alert("Plop");});
		
		this.@com.ebmwebsourcing.gwt.raphael.client.core.Raphael::getJsRef()().onclick(function(){$wnd.alert("canvasClick");});

	}-*/
	
	
	
	
	/**
	 * Return JavaScript reference to current canvas
	 * 
	 * @return JavaScriptObject
	 */
	public JavaScriptObject getJsRef() {
		return jsRef;
	}
	
	
	public void removeElement(SVGElement svgElement){
		
		this.svgElements.remove(svgElement);
		svgElement.remove();
		
		
		
	}
	
	/**
	 * Add an SVG element to the canvas only if it haven't been added yet
	 * @param svgElement
	 */
	public void addElement(SVGElement svgElement){
		
		if (this.svgElements.contains(svgElement)==false){
			this.svgElements.add(svgElement);
			svgElement.setCanvas(this);
			svgElement.addJsElementToCanvas();			
		
		}else{
			
			throw new IllegalStateException("Cannot add the same element twice in the SVG canvas.");
		}

		
	}
	
	public boolean isAttached(SVGElement element){
		return svgElements.contains(element);
	}
	
	public ArrayList<SVGElement> getSvgElements() {
		return svgElements;
	}
	
}
