/**
 * Raphael for GWT - A crossbrowser SVG/VML library for GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.gwt.raphael.client.core;

import com.google.gwt.core.client.JavaScriptObject;

public class Rectangle extends SVGElement {
	

	private int radius;
	
	public Rectangle(String id,int x,int y,int width,int height,int radius) {
	
		super(id,x,y);
	
		this.setWidth(width);
		this.setHeight(height);
		this.radius	= radius;
		
	}
	

	
	public int getRadius() {
		return radius;
	}
	
	

	protected native void setJSX(JavaScriptObject jsObj,int x)/*-{
		jsObj.attr("x",x);
	}-*/;

	
	protected native void setJSY(JavaScriptObject jsObj,int y)/*-{
		jsObj.attr("y",y);
	}-*/;
		
	@Override
	protected JavaScriptObject addConcreteJavascriptElementToCanvas() {
		return this.addRectToCanvas(this.getCanvas().getJsRef(), this.getX(), this.getY(),this.getWidth(),this.getHeight(), this.getRadius());
	}
	
	
	protected native JavaScriptObject addRectToCanvas(JavaScriptObject jsObj, int x, int y,int w,int h, int r)/*-{
		return jsObj.rect(x,y,w,h,r);
	}-*/;

	@Override
	protected native void setJSHeight(JavaScriptObject jsObj, int height)/*-{
		jsObj.attr("height",height);
	}-*/;

	@Override
	protected native void setJSWidth(JavaScriptObject jsObj, int width)/*-{
		jsObj.attr("width",width);
	}-*/;


}
