/**
 * Raphael for GWT - A crossbrowser SVG/VML library for GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.gwt.raphael.client.core;


import com.ebmwebsourcing.gwt.raphael.client.core.jsniimpl.SVGElementJSNIImpl;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Widget;

public abstract class SVGElement extends Widget implements HasClickHandlers{

	


	private JavaScriptObject jsRef;
	
	private String id;
	
	protected int x;
	
	protected int y;
	
	protected int width;
	
	protected int height;
	
	private Raphael canvas;
	
	private SVGElementJSNIImpl jsniImpl;
	
	private boolean isLoaded=false;
	
	/**
	 * 
	 * @param id
	 * @param x the left coord
	 * @param y the top coord 
	 */
	public SVGElement(String id,int x,int y){
		
		this.id = id;
		this.x 	= x;
		this.y 	= y;
		
		this.jsniImpl = new SVGElementJSNIImpl(this);
		
		sinkEvents(Event.ONCLICK);
		
	}
	
	public SVGElement(String id){
		this(id, 0,0);
	}
	
	
	public boolean isLoaded(){
		return this.isLoaded;
	}
	
	
	public String getId() {
		return id;
	}
	

	public int getX() {
		return x;
	}
	

	public int getY(){
		return y;
	}
	
	

	public void setX(int x){
		
		if (isLoaded) this.setJSX(getJsref(), x);
		
		this.x = x;
	}
	

	public void setY(int y){
		
		if (isLoaded) this.setJSY(getJsref(), y);
		
		this.y = y;
	}
	
	
	public void setWidth(int width){
		
		if (isLoaded) this.setJSWidth(getJsref(), width);
	
		this.width = width;
	
	}
	
	public void setHeight(int height){
	
		if (isLoaded) this.setJSHeight(getJsref(), height);
	
		this.height = height;
	
	}
	
	
	protected abstract void setJSX(JavaScriptObject jsObj,int x);
	protected abstract void setJSY(JavaScriptObject jsObj,int y);
	
	protected abstract void setJSWidth(JavaScriptObject jsObj,int x);
	protected abstract void setJSHeight(JavaScriptObject jsObj,int x);
	
	
	
	/**
	 * Set the JavaScript reference of 
	 * the current element
	 * @param jsref
	 */
	protected void setJsref(JavaScriptObject jsref) {
		this.jsRef = jsref;
	}
	

	public JavaScriptObject getJsref() {
		return jsRef;
	}


	public void setCanvas(Raphael raphael) {
		this.canvas = raphael;
	}
	

	public Raphael getCanvas(){
		return this.canvas;
	}
	
	protected void addJsElementToCanvas(){
		
		this.jsRef = addConcreteJavascriptElementToCanvas();
		setElement(jsniImpl.node());
		
		this.isLoaded = true;
		
		this.setX(getX());
		this.setY(getY());
		
		this.setWidth(getWidth());
		this.setHeight(getHeight());
		
		onAttach();
	}
	
	
	

	public void remove(){
		if (isLoaded) this.jsniImpl.remove();
		this.canvas.getSvgElements().remove(this);
	}

	public void hide(){
		if (isLoaded) this.jsniImpl.hide();
	}

	

	public void show(){
		if (isLoaded) this.jsniImpl.show();		
	}

	
	public void scale(double Xtimes,double Ytimes){
		if (isLoaded) this.jsniImpl.scale(Xtimes, Ytimes);
	}
	
	public void scale(double Xtimes,double Ytimes,double centerX,double centerY){
		if (isLoaded) this.jsniImpl.scale(Xtimes, Ytimes, centerX, centerY);
	}
	
	public void attr(String attributeName,String value){
		if (isLoaded) this.jsniImpl.attr(attributeName, value);
	}
	
	
	public String attr(String attributeName){
		return this.jsniImpl.attr(attributeName);
	}
	
	public void animate(JavaScriptObject newAttrs,int ms){
		if (isLoaded) this.jsniImpl.animate(newAttrs, ms);
	}
	
	public void rotate(int degree, boolean isAbsolute){
		if (isLoaded) this.jsniImpl.rotate(degree, isAbsolute);
	}

	

	public void rotate(int degree, int cx, int cy){
		if (isLoaded) this.jsniImpl.rotate(degree, cx, cy);
	}
	
	
	public void toBack(){
		if (isLoaded) this.jsniImpl.toBack();
	}
	
	public void toFront(){
		if (isLoaded) this.jsniImpl.toFront();
	}

	public void translate(int dx,int dy){
		if (isLoaded) this.jsniImpl.translate(dx, dy);
	}
	

	public int getWidth(){
		return  width;
	}
	

	public  int getHeight(){
		return height;
	}

	
	@Override
	public boolean equals(Object obj) {
		
		SVGElement elToCompare = (SVGElement) obj;
		
		if (elToCompare.getId().equals(this.getId())){
			
			return true;
			
		}
		
		return false;
	}
	
	
	public SVGElementJSNIImpl getJsniImpl() {
		return jsniImpl;
	}
	
	@Override
	public int hashCode() {
		return this.getId().hashCode();
	}
	
	protected abstract JavaScriptObject addConcreteJavascriptElementToCanvas();

	public HandlerRegistration addClickHandler(ClickHandler handler) {
		return addHandler(handler, ClickEvent.getType());
	}
		
}
