/**
 * Raphael for GWT - A crossbrowser SVG/VML library for GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.gwt.raphael.client.core;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONObject;

public interface SVGElementInterface {



	/**
	 * Removes element from the DOM. You can’t use it after this method call. 
	 */
	public abstract void remove();
	
	/**
	 * Make element invisible.
	 */
	public abstract void hide();
	
	/**
	 * Makes element visible. 
	 */
	public abstract void show();

	public abstract void attr(String attributeName, String value);
	
	public abstract String attr(String attributeName);
	
	
	/**
	 * Rotates the element by the given degree from its center point. 
	 * 
	 * @param int degree Degree of rotation (0 – 360°)
	 * @param boolean isAbsolute [optional] Specifies is degree is relative to <br> previous position (false) or is it absolute angle (true)
	 */
	public abstract void rotate(int degree, boolean isAbsolute);

	/**
	 * Rotates the element by the given degree from its center point. 
	 * 
	 * @param int degree Degree of rotation (0 – 360°)
	 * @param int cx [optional] X coordinate of the origin of rotation
	 * @param int cy [optional] Y coordinate of the origin of rotation
	 */
	public abstract void rotate(int degree, int cx, int cy);

	/**
	 * Moves the element around the canvas by the given distances.
	 * 
	 * @param int dx Pixels of translation by X axis
	 * @param int dy Pixels of translation by Y axis
	 */
	public abstract void translate(int dx, int dy);

	/**
	 * Resizes the element by the given multiplier.
	 * 
	 * @param int xTimes
	 * @param int yTimes
	 */
	public abstract void scale(double xTimes,double yTimes);

	/**
	 * Resizes the element by the given multiplier.
	 * 
	 * @param int xTimes
	 * @param int yTimes
	 * @param int centerX
	 * @param int centerY
	 */
	public abstract void scale(double xTimes,double yTimes,double centerX,double centerY);
	
	/**
	 * Changes an attribute from its current value to its specified value <br>
	 * in the given amount of milliseconds
	 * 
	 * @param JSONObject newAttrs
	 * @param int ms 
	 */
	public abstract void animate(JavaScriptObject newAttrs,int ms);
	
	/**
	 * The same as animate method, but synchronise animation with another element. 
	 * @param JavaScriptObject svgElement
	 * @param JSONObject newAttrs
	 * @param int ms
	 */
	public abstract void animateWith(JavaScriptObject svgElement,JSONObject newAttrs,int ms);
	
	public abstract void toFront();
	
	public abstract void toBack();
	
	/**
	 * Inserts current object before the given one. 
	 * @param JavaScriptObject jsElement
	 */
	public abstract void insertBefore(JavaScriptObject jsElement);
	
	/**
	 * Inserts current object after the given one. 
	 * @param JavaScriptObject jsElement
	 */
	public abstract void insertAfter(JavaScriptObject jsElement);
	
//	public abstract void clone();
	

	
	
	/**
	 * Returns elements with based on BBox.width
	 * @return int Element Width
	 */
	public abstract double getWidth();
	
	
	/**
	 * Returns elements with based on BBox.height
	 * @return int Element Height
	 */
	public abstract double getHeight();
	
	
	

}