/**
 * Raphael for GWT - A crossbrowser SVG/VML library for GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.gwt.raphael.client.core;

import com.google.gwt.core.client.JavaScriptObject;

public class Text extends SVGElement{
	
	private String text;
	
	/**
	 * 	 * TODO: Width and height in constructor ?
	 * @param id
	 * @param text
	 * @param x
	 * @param y
	 */
	public Text(String id,String text,int x,int y){
		super(id, x, y);
		
		this.text = text;
		
	}
	
	
	public String getText() {
		return text;
	}
	
	@Override
	protected JavaScriptObject addConcreteJavascriptElementToCanvas() {
		return this.addTextToCanvas(this.getCanvas().getJsRef(), text, getX(), getY());
	}

	
	protected native JavaScriptObject addTextToCanvas(JavaScriptObject jsObj,String text,int x,int y)/*-{
		return 	jsObj.text(x,y,text);
	}-*/;
	

	@Override
	protected void addJsElementToCanvas() {
		super.addJsElementToCanvas();
		
		setWidth((int)getJsniImpl().getWidth());
		setHeight((int)getJsniImpl().getHeight());
		
	}
	
	
	protected native void setJSX(JavaScriptObject jsObj,int x)/*-{
		jsObj.attr("x",x);
	}-*/;

	
	protected native void setJSY(JavaScriptObject jsObj,int y)/*-{
		jsObj.attr("y",y);
	}-*/;


	@Override
	protected void setJSHeight(JavaScriptObject jsObj, int x) {
		// TODO Auto-generated method stub
		
	}


	@Override
	protected void setJSWidth(JavaScriptObject jsObj, int x) {
		// TODO Auto-generated method stub
		
	}



	
	
}
