/**
 * Raphael for GWT - A crossbrowser SVG/VML library for GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.gwt.raphael.client.core.jsniimpl;


import com.ebmwebsourcing.gwt.raphael.client.core.SVGElement;
import com.ebmwebsourcing.gwt.raphael.client.core.SVGElementInterface;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.user.client.Element;

public class SVGElementJSNIImpl implements SVGElementInterface{

	private SVGElement svgelement;
	
	public SVGElementJSNIImpl(SVGElement svgelement){
		
		this.svgelement = svgelement;
		
	}
	
	public JavaScriptObject getJsRef() {
		return svgelement.getJsref();
	}

	public native void attr(String attributeName, String value) /*-{
		this.@com.ebmwebsourcing.gwt.raphael.client.core.jsniimpl.SVGElementJSNIImpl::getJsRef()().attr(attributeName,value);	
	}-*/;

	
	public native String attr(String attributeName) /*-{
		return this.@com.ebmwebsourcing.gwt.raphael.client.core.jsniimpl.SVGElementJSNIImpl::getJsRef()().attr(attributeName);
	}-*/;
	
	public native void hide() /*-{
		this.@com.ebmwebsourcing.gwt.raphael.client.core.jsniimpl.SVGElementJSNIImpl::getJsRef()().hide();	
	}-*/;
	
	
	public native void remove() /*-{
		this.@com.ebmwebsourcing.gwt.raphael.client.core.jsniimpl.SVGElementJSNIImpl::getJsRef()().remove();	
	}-*/;

	public native void rotate(int degree, boolean isAbsolute) /*-{
		this.@com.ebmwebsourcing.gwt.raphael.client.core.jsniimpl.SVGElementJSNIImpl::getJsRef()().rotate(degree,isAbsolute);	
	}-*/;

	public native void rotate(int degree, int cx, int cy)/*-{
		this.@com.ebmwebsourcing.gwt.raphael.client.core.jsniimpl.SVGElementJSNIImpl::getJsRef()().rotate(degree,cx,cy);	
	}-*/;

	public native void show() /*-{
		this.@com.ebmwebsourcing.gwt.raphael.client.core.jsniimpl.SVGElementJSNIImpl::getJsRef()().show();	
	}-*/;


	public native void translate(int dx, int dy)/*-{
		this.@com.ebmwebsourcing.gwt.raphael.client.core.jsniimpl.SVGElementJSNIImpl::getJsRef()().translate(dx,dy);	
	}-*/;

	
	public native double getHeight() /*-{
		return this.@com.ebmwebsourcing.gwt.raphael.client.core.jsniimpl.SVGElementJSNIImpl::getJsRef()().getBBox().height;	
	}-*/;

	
	public native double getWidth() /*-{
		return this.@com.ebmwebsourcing.gwt.raphael.client.core.jsniimpl.SVGElementJSNIImpl::getJsRef()().getBBox().width;	
	}-*/;


	public native void animate(JavaScriptObject newAttrs, int ms)/*-{
		this.@com.ebmwebsourcing.gwt.raphael.client.core.jsniimpl.SVGElementJSNIImpl::getJsRef()().animate(newAttrs,ms);	
	}-*/;

	
	public native void animateWith(JavaScriptObject svgElement, JSONObject newAttrs,int ms)/*-{
		this.@com.ebmwebsourcing.gwt.raphael.client.core.jsniimpl.SVGElementJSNIImpl::getJsRef()().animateWith(svgElement,newAttrs,ms);	
	}-*/;

	
	public native void insertAfter(JavaScriptObject jsElement)/*-{
		this.@com.ebmwebsourcing.gwt.raphael.client.core.jsniimpl.SVGElementJSNIImpl::getJsRef()().insertAfter(jsElement);	
	}-*/;

	
	public native void insertBefore(JavaScriptObject jsElement)/*-{
		this.@com.ebmwebsourcing.gwt.raphael.client.core.jsniimpl.SVGElementJSNIImpl::getJsRef()().insertBefore(jsElement);	
	}-*/;

	
	public native void scale(double Xtimes, double Ytimes)/*-{
		this.@com.ebmwebsourcing.gwt.raphael.client.core.jsniimpl.SVGElementJSNIImpl::getJsRef()().scale(Xtimes,Ytimes);	
	}-*/;

	
	public native void scale(double Xtimes, double Ytimes, double centerX, double centerY)/*-{
		this.@com.ebmwebsourcing.gwt.raphael.client.core.jsniimpl.SVGElementJSNIImpl::getJsRef()().scale(Xtimes,Ytimes,centerX,centerY);	
	}-*/;

	
	public native void toBack()/*-{
		this.@com.ebmwebsourcing.gwt.raphael.client.core.jsniimpl.SVGElementJSNIImpl::getJsRef()().toBack();	
	}-*/;

	
	public native void toFront()/*-{
		this.@com.ebmwebsourcing.gwt.raphael.client.core.jsniimpl.SVGElementJSNIImpl::getJsRef()().toFront();	
	}-*/;
	
	public native Element node()/*-{
		return this.@com.ebmwebsourcing.gwt.raphael.client.core.jsniimpl.SVGElementJSNIImpl::getJsRef()().node;
	}-*/;
}
