/**
 * BPMN Editor Client - Client for the BPMN Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.presentation.gwt.client;


import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.mock.MockDefinitionsDB;
import com.ebmwebsourcing.bpmneditor.presentation.gwt.client.bpmneditor.BPMNEditor;
import com.ebmwebsourcing.bpmneditor.presentation.gwt.client.bpmneditor.bpmn2.renderer.DefinitionsSyntaxModel;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.event.DesignerListenerAdapter;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.layout.DefaultLayout;
import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RootPanel;
import com.gwtext.client.widgets.MessageBox;
import com.gwtext.client.widgets.Panel;



/**
 * Entry point for the BPMN Editor <br>
 * with every default functionalities and views enabled<br>
 * 
 * @author nfleury
 *
 */
public class BPMNEditorClient implements EntryPoint{

	private BPMNEditor editor;
	

	public void onModuleLoad() {
		


		DeferredCommand.addCommand(new Command(){
			public void execute() {
				editor.doLayout();
				editor.getController().unmask();
			}
		});
		


	try{
			//can be useful in production mode
			this.editor = new BPMNEditor();
			
			
		}catch (Throwable e) {
			
				MessageBox.alert("Unknown Exception:"+e.getMessage());
		
		}
		

		
		this.editor.addDesignerListener(new DesignerListenerAdapter(){
			@Override
			public void onLoad() {
				
				Panel welcomePanel = new Panel("Welcome in Geasy BPMN Editor");
				welcomePanel.setClosable(true);
				welcomePanel.setCollapsible(true);
				welcomePanel.setAutoHeight(true);
				
				HTML m = new HTML("<div style='height:300px;width:1px;float:left;'></div>");
				
				welcomePanel.add(m);
				
				HTML header = new HTML();
				header.setStyleName("welcome-header");
				header.setHeight("500");
				
				
				
				Label lbl_newProcess = new Label("Create a new BPMN 2.0 process");
				Label lbl_version = new Label("version 1.0 alpha");
				lbl_version.setStyleName("version-label");
				
				lbl_newProcess.setStyleName("home-label");
				
				Label lbl_sampleProcess = new Label("Load a sample process");
				lbl_sampleProcess.setStyleName("home-label");
				
				lbl_newProcess.addClickHandler(new ClickHandler(){
					public void onClick(ClickEvent arg0) {
						
						editor.getDefsController().createNewDefinitionsDiagram();
						
					}
				});
				
				
				lbl_sampleProcess.addClickHandler(new ClickHandler(){
					public void onClick(ClickEvent arg0) {
						
						editor.getDefsController().loadDefsDiagram(new DefinitionsSyntaxModel(MockDefinitionsDB.generateExample()));
						
					}
				});
				
				welcomePanel.add(lbl_version);
				welcomePanel.add(lbl_newProcess);
				welcomePanel.add(lbl_sampleProcess);
				
				welcomePanel.add(header);
				welcomePanel.doLayout();
				editor.getDiagramLayout().getDrawingPanelTab().add(welcomePanel);
				editor.getDiagramLayout().getDrawingPanelTab().activate(0);
				//editor.getCpatController().createNewCPatDiagram();
				
				((DefaultLayout)editor.getDiagramLayout()).getSouthPanel().setCollapsed(true);
				
				editor.doLayout();
				
				
				
			}
		});


		RootPanel.get().add(editor);
		editor.getController().mask("Loading designer, please wait ...");
		  


		
	}
	
	


}
