/**
 * BPMN Editor Domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.mock;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.Constants.ProcessTypes;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.collaboration.CollaborationBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.collaboration.LaneBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.collaboration.LaneSetBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.collaboration.PoolBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.common.FlowNodeBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.common.ItemDefinitionBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.common.MessageBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.common.MessageFlowBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.common.ParticipantBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.common.PartnerRoleBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.infrastructure.DefinitionsBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.infrastructure.ImportBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.ProcessBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.activity.ReceiveTaskBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.activity.SendTaskBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.activity.TaskBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.event.EndEventBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.event.StartEventBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.event.definition.EventDefinitionBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.event.definition.MessageEventDefinitionBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.gateway.ExclusiveGatewayBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.gateway.SequenceFlowBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.service.InterfaceBean;

public class MockDefinitionsDB {
	
	private static int i = 0;

	public static DefinitionsBean generateExample() {
		List<FlowNodeBean> upperPoolNodes = new ArrayList<FlowNodeBean>();
		List<FlowNodeBean> lowerPoolNodes = new ArrayList<FlowNodeBean>();
		
		DefinitionsBean result = new DefinitionsBean(createUniqueId());
		
		result.setTargetNamespace("http://com.ebmwebsourcing.easybpmn/creatingIdea/definition");
		result.setTypeLanguage("http://www.w3.org/2001/XMLSchema");
		result.setExpressionLanguage("http://www.w3.org/1999/XPath");
		
		ImportBean iBean = new ImportBean();
		iBean.setImportType("http://www.w3.org/2001/XMLSchema");
		iBean.setLocation("creatingIdea.xsd");
		iBean.setNamespace("http://com.ebmwebsourcing.easybpmn/creatingIdea/data");
		
//		SchemaBean schema = new SchemaBean();
//		iBean.setSchema(schema);
//		schema.addElement(new ElementBean("input", new BasicType(BasicTypes.STRING), schema));

		List<MessageBean> messages = buildMessages();
		result.setMessages(messages);
		
		result.addCollaboration(buildCollaboration(result,upperPoolNodes,lowerPoolNodes));
		
		return result;
	}

	//TODO
	private static List<MessageBean> buildMessages() {
		List<MessageBean> result = new ArrayList<MessageBean>();
		
		MessageBean msg1 = new MessageBean(createUniqueId());
		msg1.setName("");
		ItemDefinitionBean idb1 = new ItemDefinitionBean(createUniqueId());
		msg1.setItemDefinition(idb1);
		
		return result;
	}

	private static CollaborationBean buildCollaboration(DefinitionsBean globalResult,List<FlowNodeBean> upperPoolNodes,List<FlowNodeBean> lowerPoolNodes) {
		CollaborationBean result = new CollaborationBean(createUniqueId());
		result.setName("creatingIdeaCollaboration");
		result.addPool(buildUpperPool(globalResult,upperPoolNodes));
		result.addPool(buildlowerPool(globalResult,lowerPoolNodes));
		result.setMessageFlows(buildMessageFlows(upperPoolNodes,lowerPoolNodes));
		return result;
	}

	private static PoolBean buildUpperPool(DefinitionsBean globalResult,List<FlowNodeBean> upperPoolNodes) {
		PoolBean result = new PoolBean(createUniqueId());
		result.setName("VO member (idea creator)");

		//TODO
		InterfaceBean itfBean = new InterfaceBean(createUniqueId());
//		itfBean.setName();
//		itfBean.setOperations();
		
		result.setX_left(10);
		result.setY_left(10);
		result.setX_right(1160);
		result.setY_right(210);
		
		ParticipantBean participant = new ParticipantBean(createUniqueId());
		PartnerRoleBean pr = new PartnerRoleBean(createUniqueId());
		pr.setName(result.getName());
		participant.setPartnerRole(pr);
		result.setParticipant(participant);
		
		globalResult.addPartnerRole(pr);
		
		ProcessBean process = new ProcessBean(createUniqueId());
		process.setName(process.getId());
		process.setType(ProcessTypes.EXECUTABLE);
		globalResult.addProcess(process);
		result.setProcess(process);
		LaneSetBean laneSet = new LaneSetBean(createUniqueId());
		process.addLaneSet(laneSet);
		laneSet.addLane(buildUpperLane(upperPoolNodes));
		return result;
	}
	
	private static LaneBean buildUpperLane(List<FlowNodeBean> upperPoolNodes) {
		LaneBean result = new LaneBean(createUniqueId());
		result.setName("VO Member (idea creator)");
		result.setX_left(10);
		result.setY_left(10);
		result.setX_right(1160);
		result.setY_right(110);
		
		//NODES
		StartEventBean startEvent = new StartEventBean(createUniqueId());
		startEvent.setName("VO Member ...");
		EventDefinitionBean ed = new MessageEventDefinitionBean(createUniqueId());
		((MessageEventDefinitionBean)ed).setMessageQName("");
		startEvent.addTrigger(ed);
		startEvent.setX_left(10);
		startEvent.setY_left(60);
		result.addStartEvent(startEvent);
		
		ReceiveTaskBean task1 = new ReceiveTaskBean(createUniqueId());
		task1.setName("Fill in idea entry \r\n template");
		task1.setX_left(70);
		task1.setY_left(50);
		result.addTask(task1);
		
		TaskBean task2 = new TaskBean(createUniqueId());
		task2.setName("Store in VO's \r\n KB");
		task2.setX_left(200);
		task2.setY_left(50);
		result.addTask(task2);
		
		SendTaskBean task3 = new SendTaskBean(createUniqueId());
		task3.setName("Send \r\n Template");
		task3.setX_left(330);
		task3.setY_left(50);
		result.addTask(task3);
		upperPoolNodes.add(task3);
		
		ReceiveTaskBean task4 = new ReceiveTaskBean(createUniqueId());
		task4.setName("Receive \r\n comments");
		task4.setX_left(460);
		task4.setY_left(50);
		result.addTask(task4);
		upperPoolNodes.add(task4);
		
		SendTaskBean task5 = new SendTaskBean(createUniqueId());
		task5.setName("Send \r\n decision");
		task5.setX_left(590);
		task5.setY_left(50);
		result.addTask(task5);
		upperPoolNodes.add(task5);
		
		ExclusiveGatewayBean gateway = new ExclusiveGatewayBean(createUniqueId());
		gateway.setX_left(720);
		gateway.setY_left(77);
		result.addGateway(gateway);

		TaskBean task6 = new TaskBean(createUniqueId());
		task6.setName("Store in \r\n VO's KB");
		task6.setX_left(780);
		task6.setY_left(10);
		result.addTask(task6);
		
		TaskBean task7 = new TaskBean(createUniqueId());
		task7.setName("Decide on \r\n rejection");
		task7.setX_left(780);
		task7.setY_left(130);
		result.addTask(task7);
		
		TaskBean task8 = new TaskBean(createUniqueId());
		task8.setName("Decide on \r\n rejection");
		task8.setX_left(910);
		task8.setY_left(130);
		result.addTask(task8);
		
		EndEventBean endEvent = new EndEventBean(createUniqueId());
		endEvent.setResults(null);
		endEvent.setX_left(1080);
		endEvent.setY_left(80);
		result.addEndEvent(endEvent);
		
		//SEQUENCE FLOWS
		SequenceFlowBean sf1 = new SequenceFlowBean(createUniqueId());
		sf1.setSourceNode(startEvent);
		sf1.setTargetNode(task1);
		result.addSequenceFlow(sf1);
		
		SequenceFlowBean sf2 = new SequenceFlowBean(createUniqueId());
		sf2.setSourceNode(task1);
		sf2.setTargetNode(task2);
		result.addSequenceFlow(sf2);
		
		SequenceFlowBean sf3 = new SequenceFlowBean(createUniqueId());
		sf3.setSourceNode(task2);
		sf3.setTargetNode(task3);
		result.addSequenceFlow(sf3);
		
		SequenceFlowBean sf4 = new SequenceFlowBean(createUniqueId());
		sf4.setSourceNode(task3);
		sf4.setTargetNode(task4);
		result.addSequenceFlow(sf4);
		
		SequenceFlowBean sf5 = new SequenceFlowBean(createUniqueId());
		sf5.setSourceNode(task4);
		sf5.setTargetNode(task5);
		result.addSequenceFlow(sf5);
		
		SequenceFlowBean sf6 = new SequenceFlowBean(createUniqueId());
		sf6.setSourceNode(task5);
		sf6.setTargetNode(gateway);
		result.addSequenceFlow(sf6);
		
		SequenceFlowBean sf7 = new SequenceFlowBean(createUniqueId());
		sf7.setSourceNode(gateway);
		sf7.setTargetNode(task6);
		result.addSequenceFlow(sf7);
		
		SequenceFlowBean sf8 = new SequenceFlowBean(createUniqueId());
		sf8.setSourceNode(gateway);
		sf8.setTargetNode(task7);
		result.addSequenceFlow(sf8);
		
		SequenceFlowBean sf9 = new SequenceFlowBean(createUniqueId());
		sf9.setSourceNode(task6);
		sf9.setTargetNode(endEvent);
		result.addSequenceFlow(sf9);
		
		SequenceFlowBean sf10 = new SequenceFlowBean(createUniqueId());
		sf10.setSourceNode(task7);
		sf10.setTargetNode(task8);
		result.addSequenceFlow(sf10);
		
		SequenceFlowBean sf11 = new SequenceFlowBean(createUniqueId());
		sf11.setSourceNode(task8);
		sf11.setTargetNode(endEvent);
		result.addSequenceFlow(sf11);
		
		return result;
	}

	private static PoolBean buildlowerPool(DefinitionsBean globalResult,List<FlowNodeBean> lowerPoolNodes) {
		PoolBean result = new PoolBean(createUniqueId());
		result.setName("VO memberS");
		
		result.setX_left(10);
		result.setY_left(250);
		result.setX_right(910);
		result.setY_right(450);
		
		ParticipantBean participant = new ParticipantBean(createUniqueId());
		PartnerRoleBean pr = new PartnerRoleBean(createUniqueId());
		pr.setName(result.getName());
		participant.setPartnerRole(pr);
		result.setParticipant(participant);
		
		globalResult.addPartnerRole(pr);
		
		ProcessBean process = new ProcessBean(createUniqueId());
		process.setName(process.getId());
		process.setType(ProcessTypes.EXECUTABLE);
		globalResult.addProcess(process);
		result.setProcess(process);
		LaneSetBean laneSet = new LaneSetBean(createUniqueId());
		process.addLaneSet(laneSet);
		laneSet.addLane(buildLowerLane(lowerPoolNodes));
		return result;
	}
	
	private static LaneBean buildLowerLane(List<FlowNodeBean> lowerPoolNodes) {
		LaneBean result = new LaneBean(createUniqueId());
		result.setName("VO Member (idea creator)");
		result.setX_left(10);
		result.setY_left(10);
		result.setX_right(910);
		result.setY_right(110);
		
		//NODES
		ReceiveTaskBean task1 = new ReceiveTaskBean(createUniqueId());
		task1.setName("Receive");
		task1.setX_left(70);
		task1.setY_left(50);
		result.addTask(task1);
		lowerPoolNodes.add(task1);
		
		SendTaskBean task2 = new SendTaskBean(createUniqueId());
		task2.setName("Send \r\n Components");
		task2.setX_left(200);
		task2.setY_left(50);
		result.addTask(task2);
		lowerPoolNodes.add(task2);
		
		ReceiveTaskBean task3 = new ReceiveTaskBean(createUniqueId());
		task3.setName("Receive \r\n Decision");
		task3.setX_left(330);
		task3.setY_left(50);
		result.addTask(task3);
		lowerPoolNodes.add(task3);
		
		ExclusiveGatewayBean gateway = new ExclusiveGatewayBean(createUniqueId());
		gateway.setX_left(460);
		gateway.setY_left(77);
		result.addGateway(gateway);
		
		TaskBean task4 = new TaskBean(createUniqueId());
		task4.setName("Final idea \r\n notification");
		task4.setX_left(520);
		task4.setY_left(10);
		result.addTask(task4);
		
		TaskBean task5 = new TaskBean(createUniqueId());
		task5.setName("Receive reaction \r\n on rejection");
		task5.setX_left(520);
		task5.setY_left(130);
		result.addTask(task5);
		
		TaskBean task6 = new TaskBean(createUniqueId());
		task6.setName("Project plan \r\n notification");
		task6.setX_left(650);
		task6.setY_left(10);
		result.addTask(task6);
		
		EndEventBean endEvent = new EndEventBean(createUniqueId());
		endEvent.setResults(null);
		endEvent.setX_left(800);
		endEvent.setY_left(80);
		result.addEndEvent(endEvent);
		
		//SEQUENCE FLOWS
		SequenceFlowBean sf1 = new SequenceFlowBean(createUniqueId());
		sf1.setSourceNode(task1);
		sf1.setTargetNode(task2);
		result.addSequenceFlow(sf1);
		
		SequenceFlowBean sf2 = new SequenceFlowBean(createUniqueId());
		sf2.setSourceNode(task2);
		sf2.setTargetNode(task3);
		result.addSequenceFlow(sf2);
		
		SequenceFlowBean sf3 = new SequenceFlowBean(createUniqueId());
		sf3.setSourceNode(task3);
		sf3.setTargetNode(gateway);
		result.addSequenceFlow(sf3);
		
		SequenceFlowBean sf4 = new SequenceFlowBean(createUniqueId());
		sf4.setSourceNode(gateway);
		sf4.setTargetNode(task4);
		result.addSequenceFlow(sf4);
		
		SequenceFlowBean sf5 = new SequenceFlowBean(createUniqueId());
		sf5.setSourceNode(gateway);
		sf5.setTargetNode(task5);
		sf5.setName("Comments");
		result.addSequenceFlow(sf5);
		
		SequenceFlowBean sf6 = new SequenceFlowBean(createUniqueId());
		sf6.setSourceNode(task4);
		sf6.setTargetNode(task6);
		result.addSequenceFlow(sf6);
		
		SequenceFlowBean sf7 = new SequenceFlowBean(createUniqueId());
		sf7.setSourceNode(task5);
		sf7.setTargetNode(endEvent);
		sf7.setName("Decision");
		result.addSequenceFlow(sf7);
		
		SequenceFlowBean sf8 = new SequenceFlowBean(createUniqueId());
		sf8.setSourceNode(task6);
		sf8.setTargetNode(endEvent);
		sf8.setName("Template");
		result.addSequenceFlow(sf8);
		
		return result;
	}

	private static List<MessageFlowBean> buildMessageFlows(List<FlowNodeBean> upperPoolNodes,List<FlowNodeBean> lowerPoolNodes) {
		List<MessageFlowBean> result = new ArrayList<MessageFlowBean>();
		
		MessageFlowBean messageFlow1 = new MessageFlowBean(createUniqueId());
		messageFlow1.setSource(upperPoolNodes.get(0));
		messageFlow1.setTarget(lowerPoolNodes.get(0));
		
		MessageFlowBean messageFlow2 = new MessageFlowBean(createUniqueId());
		messageFlow2.setSource(lowerPoolNodes.get(1));
		messageFlow2.setTarget(upperPoolNodes.get(1));
		
		MessageFlowBean messageFlow3 = new MessageFlowBean(createUniqueId());
		messageFlow3.setSource(upperPoolNodes.get(2));
		messageFlow3.setTarget(lowerPoolNodes.get(2));
		
		result.add(messageFlow1);
		result.add(messageFlow2);
		result.add(messageFlow3);
		
		return result;
	}
	
	private static String createUniqueId(){
		i++;
		return new Date().getTime()+"id"+i;
	}
}
