/**
 * BPMN Editor Domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard;

import java.io.Serializable;


public interface Constants extends Serializable{

	public enum BasicTypes{
		STRING("string"),
		INT("int"),
		BOOLEAN("boolean"),
		FLOAT("float"),
		DOUBLE("double"),
		DATE("dateTime");

		private String value;

		private BasicTypes(String value){
			this.value = value;
		}

		public String getValue(){
			return value;
		}

		public boolean equals(BasicTypes other){
			return this.value.equals(other.getValue());
		}
		
		public static BasicTypes fromValue(String value){
			for(BasicTypes bt : BasicTypes.values()){
				if(bt.getValue().equals(value)){
					return bt;
				}
			}
			return null;
		}
	}


	public enum ProcessTypes{
		NONE("none"),
		PUBLIC("public"),
		EXECUTABLE("executable"),
		NON_EXECUTABLE("non-executable");

		private final String value;

		private ProcessTypes(String value){
			this.value = value;
		}

		private String getValue(){
			return value;
		}

		public boolean equals(ProcessTypes other){
			return this.value.equals(other.getValue());
		}
	}

	public enum EventDefinitionType {
		MESSAGE_EVENT_DEFINITION("MessageEventDefinition"), 
		COMPENSATE_EVENT_DEFINITION("CompensateEventDefinition"), 
		CONDITIONAL_EVENT_DEFINITION("ConditionalEventDefinition"), 
		ERROR_EVENT_DEFINITION("ErrorEventDefinition"), 
		LINK_EVENT_DEFINITION("LinkEventDefinition"), 
		SIGNAL_EVENT_DEFINITION("SignalEventDefinition"), 
		TERMINATE_EVENT_DEFINITION("TerminateEventDefinition"), 
		TIMER_EVENT_DEFINITION("TimerEventDefinition"), 
		ESCALATION_EVENT_DEFINITION("ErrorEventDefinition"), 
		CANCEL_EVENT_DEFINITION("CancelEventDefinition");

		private String value = null;

		private EventDefinitionType(final String value) {
			this.value = value;
		}

		public String value() {
			return this.value;
		}

		public boolean equals(final String val) {
			return this.value().equals(val);
		}

		public String toString() {
			return this.value;
		}
		
		public static EventDefinitionType fromValue(String v) {
	        for (EventDefinitionType c: EventDefinitionType.values()) {
	            if (c.value.equals(v)) {
	                return c;
	            }
	        }
	        throw new IllegalArgumentException(v);
	    }
	}
	
	public enum ItemKind {
	    INFORMATION("Information"),
	    PHYSICAL("Physical");
	    
	    private final String value;

	    ItemKind(String v) {
	        value = v;
	    }

	    public String value() {
	        return value;
	    }

	    public static ItemKind fromValue(String v) {
	        for (ItemKind c: ItemKind.values()) {
	            if (c.value.equals(v)) {
	                return c;
	            }
	        }
	        throw new IllegalArgumentException(v);
	    }
	}
	
	public enum GatewayType{
		ParallelGateway, ExclusiveGateway;
	}
	
	public enum TaskType{
		RECEIVE_TASK, SEND_TASK, SERVICE_TASK;
	}
}
