/**
 * BPMN Editor Domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.collaboration;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.common.FlowNodeBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.common.MessageFlowBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.foundation.BaseElementBean;


public class CollaborationBean extends BaseElementBean{
	
	private String name;
	private List<PoolBean> pools;
	private List<MessageFlowBean> messageFlows;
	
	public CollaborationBean(){
		super();
		pools = new ArrayList<PoolBean>();
		messageFlows = new ArrayList<MessageFlowBean>();
	}
	
	public CollaborationBean(String id){
		super(id);
	}
	
	public void addPool(PoolBean pool){
		if(pools==null){
			pools = new ArrayList<PoolBean>();
		}
		pools.add(pool);
	}
	
	public void addMessageFlow(MessageFlowBean m){
		if(messageFlows==null){
			messageFlows = new ArrayList<MessageFlowBean>();
		}
		messageFlows.add(m);
	}
	////////////////////////////////////////////
	/////                                  /////
	/////       GETTERS AND SETTERS        /////
	/////                                  /////
	////////////////////////////////////////////
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public List<PoolBean> getPools() {
		return pools;
	}
	public void setPools(List<PoolBean> pools) {
		this.pools = pools;
	}
	public List<MessageFlowBean> getMessageFlows() {
		return messageFlows;
	}
	public void setMessageFlows(List<MessageFlowBean> messageFlows) {
		this.messageFlows = messageFlows;
	}
	public List<FlowNodeBean> getFlowNodes(){
		List<FlowNodeBean> result = null;
		if(pools!=null && pools.size()!=0){
			result = new ArrayList<FlowNodeBean>();
			for(PoolBean pool : pools){
				if(pool.getProcess()!=null){
					result.addAll(pool.getProcess().getFlowNodes());
				}
			}
		}
		return result;
	}
	public FlowNodeBean getFlowNode(String id){
		FlowNodeBean result = null;
		if(pools!=null && pools.size()!=0){
			for(PoolBean pool : pools){
				if(pool.getProcess()!=null){
					FlowNodeBean node = searchNodeById(pool.getProcess().getFlowNodes(),id);
					if(node!=null){
						return node;
					}
				}
			}
		}
		return result;
	}

	private FlowNodeBean searchNodeById(List<? extends FlowNodeBean> flowNodes,String id) {
		if(flowNodes!=null){
			int i = 0;
			boolean found = false;
			while(i<flowNodes.size() && !found){
				FlowNodeBean node = flowNodes.get(i);
				if(node.getId().equals(id)){
					return node;
				}
				else{
					i++;
				}
			}
		}
		return null;
	}
	
}
