/**
 * BPMN Editor Domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.collaboration;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.common.FlowElementBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.foundation.GraphicElementBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.activity.TaskBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.event.EndEventBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.event.StartEventBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.gateway.GatewayBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.gateway.SequenceFlowBean;



public class LaneBean extends GraphicElementBean{

	private String name;
	private LaneSetBean childLaneSet;
	private List<StartEventBean> startEvents;
	private List<EndEventBean> endEvents;
	private List<TaskBean> tasks;
	private List<SequenceFlowBean> sequenceFlows;
	private List<GatewayBean> gateways;
	
	public LaneBean(){
		super();
		startEvents = new ArrayList<StartEventBean>();
		endEvents = new ArrayList<EndEventBean>();
		tasks = new ArrayList<TaskBean>();
		sequenceFlows = new ArrayList<SequenceFlowBean>();
		gateways = new ArrayList<GatewayBean>();
		name = "";
	}
	
	public LaneBean(String id){
		super(id);
		startEvents = new ArrayList<StartEventBean>();
		endEvents = new ArrayList<EndEventBean>();
		tasks = new ArrayList<TaskBean>();
		sequenceFlows = new ArrayList<SequenceFlowBean>();
		gateways = new ArrayList<GatewayBean>();
		name = "";
	}
	
	public void addStartEvent(StartEventBean s){
		if(startEvents==null){
			startEvents = new ArrayList<StartEventBean>();
		}
		startEvents.add(s);
	}
	
	public void addEndEvent(EndEventBean e){
		if(endEvents==null){
			endEvents = new ArrayList<EndEventBean>();
		}
		endEvents.add(e);
	}
	
	public void addTask(TaskBean t){
		if(tasks==null){
			tasks = new ArrayList<TaskBean>();
		}
		tasks.add(t);
	}
	
	public void addSequenceFlow(SequenceFlowBean s){
		if(sequenceFlows==null){
			sequenceFlows = new ArrayList<SequenceFlowBean>();
		}
		sequenceFlows.add(s);
	}
	
	public void addGateway(GatewayBean g){
		if(gateways==null){
			gateways = new ArrayList<GatewayBean>();
		}
		gateways.add(g);
	}
	
	public TaskBean getTaskById(String id){
		for(TaskBean tb : tasks){
			if(id.equals(tb.getId())){
				return tb;
			}
		}
		return null;
	}
	
	public GatewayBean getGatewayById(String id){
		for(GatewayBean gb : gateways){
			if(id.equals(gb.getId())){
				return gb;
			}
		}
		return null;
	}
	
	public StartEventBean getStartEventById(String id){
		for(StartEventBean seb : startEvents){
			if(id.equals(seb.getId())){
				return seb;
			}
		}
		return null;
	}
	
	public EndEventBean getEndEvent(String id){
		for(EndEventBean eeb : endEvents){
			if(id.equals(eeb.getId())){
				return eeb;
			}
		}
		return null;
	}
	
	/**
	 * Removes feb which is either a task, an event or a gateway from the lane
	 * @param feb
	 * @return true if feb was in the lane
	 */
	public boolean removeFlowElement(FlowElementBean feb){
		if(tasks.contains(feb)){
			tasks.remove(feb);
			return true;
		}
		if(gateways.contains(feb)){
			gateways.remove(feb);
			return true;
		}
		if(endEvents.contains(feb)){
			endEvents.remove(feb);
			return true;
		}
		if(startEvents.contains(feb)){
			startEvents.remove(feb);
			return true;
		}
		return false;
	}
	////////////////////////////////////////////
	/////                                  /////
	/////       GETTERS AND SETTERS        /////
	/////                                  /////
	////////////////////////////////////////////
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public LaneSetBean getChildLaneSet() {
		return childLaneSet;
	}
	public void setChildLaneSet(LaneSetBean childLaneSet) {
		this.childLaneSet = childLaneSet;
	}
	public List<StartEventBean> getStartEvents() {
		return startEvents;
	}
	public void setStartEvents(List<StartEventBean> startEvents) {
		this.startEvents = startEvents;
	}
	public List<EndEventBean> getEndEvents() {
		return endEvents;
	}
	public void setEndEvents(List<EndEventBean> endEvents) {
		this.endEvents = endEvents;
	}
	public List<TaskBean> getTasks() {
		return tasks;
	}
	public void setTasks(List<TaskBean> tasks) {
		this.tasks = tasks;
	}
	public List<SequenceFlowBean> getSequenceFlows() {
		return sequenceFlows;
	}
	public void setSequenceFlows(List<SequenceFlowBean> sequenceFlows) {
		this.sequenceFlows = sequenceFlows;
	}
	public List<GatewayBean> getGateways() {
		return gateways;
	}
	public void setGateways(List<GatewayBean> gateways) {
		this.gateways = gateways;
	}
	
}
