/**
 * BPMN Editor Domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.collaboration;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.foundation.BaseElementBean;



public class LaneSetBean extends BaseElementBean{

	private List<LaneBean> lanes;

	public LaneSetBean(String id){
		super(id);
	}
	
	public LaneSetBean(){
		super();
		lanes = new ArrayList<LaneBean>();
	}
	
	public void addLane(LaneBean l){
		if(lanes==null){
			lanes = new ArrayList<LaneBean>();
		}
		lanes.add(l);
	}
	
	public void removeLane(LaneBean l){
		if(lanes!=null){
			lanes.remove(l);
		}
	}
	////////////////////////////////////////////
	/////                                  /////
	/////       GETTERS AND SETTERS        /////
	/////                                  /////
	////////////////////////////////////////////
	public List<LaneBean> getLanes() {
		return lanes;
	}

	public void setLanes(List<LaneBean> lanes) {
		this.lanes = lanes;
	}
	
}
