/**
 * BPMN Editor Domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.infrastructure;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.collaboration.CollaborationBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.common.MessageBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.common.PartnerRoleBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.foundation.BaseElementBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.ProcessBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.service.InterfaceBean;



public class DefinitionsBean extends BaseElementBean {

	/**
	 * actual type in the api : java.net.URI
	 */
	private String documentBaseURI;
	private String targetNamespace;
	private String expressionLanguage;
	private String typeLanguage;
	private List<ImportBean> imports;
	private List<CollaborationBean> collaborations;
	private List<ProcessBean> processes; 
	private List<InterfaceBean> interfaces;
	private List<PartnerRoleBean> partnerRoles;
	private List<MessageBean> messages;
	
	// not part of bpmn2.0 specification
	private String name;
	
	public DefinitionsBean(){
		super();
		imports = new ArrayList<ImportBean>();
		collaborations = new ArrayList<CollaborationBean>();
		processes = new ArrayList<ProcessBean>();
		interfaces = new ArrayList<InterfaceBean>();
		partnerRoles = new ArrayList<PartnerRoleBean>();
		messages = new ArrayList<MessageBean>();
		targetNamespace = "";
		documentBaseURI = "";
		expressionLanguage = "";
		typeLanguage = "";
	}

	public DefinitionsBean(String id){
		super(id);
		imports = new ArrayList<ImportBean>();
		collaborations = new ArrayList<CollaborationBean>();
		processes = new ArrayList<ProcessBean>();
		interfaces = new ArrayList<InterfaceBean>();
		partnerRoles = new ArrayList<PartnerRoleBean>();
		messages = new ArrayList<MessageBean>();
		targetNamespace = "";
		documentBaseURI = "";
		expressionLanguage = "";
		typeLanguage = "";
	}

	public void addImport(ImportBean i){
		imports.add(i);
	}

	public void addCollaboration(CollaborationBean c){
		collaborations.add(c);
	}

	public void addProcess(ProcessBean p){
		processes.add(p);
	}

	public void addInterface(InterfaceBean i){
		interfaces.add(i);
	}

	public void addPartnerRole(PartnerRoleBean prb){
		partnerRoles.add(prb);
	}

	public void addMessage(MessageBean msg){
		messages.add(msg);
	}


	public ProcessBean getProcessBeanById(String id){
		ProcessBean result = null;
		if(processes!=null){
			int i = 0;
			boolean found = false;
			while(i<processes.size() && !found){
				ProcessBean p = processes.get(i);
				if(p.getId().equals(id)){
					result = p;
					found = true;
				}
				else{
					i++;
				}
			}
		}
		return result;
	}

	public InterfaceBean getInterfaceBeanById(String id){
		InterfaceBean result = null;
		if(interfaces!=null){
			int i = 0;
			boolean found = false;
			while(i<interfaces.size() && !found){
				InterfaceBean itf = interfaces.get(i);
				if(itf.getId().equals(id)){
					result = itf;
					found = true;
				}
				else{
					i++;
				}
			}
		}
		return result;
	}

	public PartnerRoleBean getPartnerRoleBeanById(String id){
		PartnerRoleBean result = null;
		if(partnerRoles!=null){
			int i = 0;
			boolean found = false;
			while(i<partnerRoles.size() && !found){
				PartnerRoleBean pr = partnerRoles.get(i);
				if(pr.getId().equals(id)){
					result = pr;
					found = true;
				}
				else{
					i++;
				}
			}
		}
		return result;
	}
	////////////////////////////////////////////
	/////                                  /////
	/////       GETTERS AND SETTERS        /////
	/////                                  /////
	////////////////////////////////////////////
	public String getName(){
		
		if (name==null){
			return getId();
		}
		
		return this.name;
	}
	
	public void setName(String name){
		this.name = name;
	}
	
	public String getDocumentBaseURI(){
		return documentBaseURI;
	}


	public String getTargetNamespace() {
		return targetNamespace;
	}


	public void setTargetNamespace(String targetNamespace) {
		this.targetNamespace = targetNamespace;
	}


	public String getExpressionLanguage() {
		return expressionLanguage;
	}


	public void setExpressionLanguage(String expressionLanguage) {
		this.expressionLanguage = expressionLanguage;
	}


	public String getTypeLanguage() {
		return typeLanguage;
	}


	public void setTypeLanguage(String typeLanguage) {
		this.typeLanguage = typeLanguage;
	}

	public List<ImportBean> getImports() {
		return imports;
	}

	public void setImports(List<ImportBean> imports) {
		this.imports = imports;
	}

	public List<CollaborationBean> getCollaborations() {
		return collaborations;
	}

	public void setCollaborations(List<CollaborationBean> collaborations) {
		this.collaborations = collaborations;
	}

	public List<ProcessBean> getProcesses() {
		return processes;
	}

	public void setProcesses(List<ProcessBean> processes) {
		this.processes = processes;
	}

	public List<InterfaceBean> getInterfaces() {
		return interfaces;
	}

	public void setInterfaces(List<InterfaceBean> interfaces) {
		this.interfaces = interfaces;
	}

	public List<PartnerRoleBean> getPartnerRoles() {
		return partnerRoles;
	}

	public void setPartnerRoles(List<PartnerRoleBean> partnerRoles) {
		this.partnerRoles = partnerRoles;
	}

	public List<MessageBean> getMessages() {
		return messages;
	}

	public void setMessages(List<MessageBean> messages) {
		this.messages = messages;
	}

	public void setDocumentBaseURI(String documentBaseURI) {
		this.documentBaseURI = documentBaseURI;
	}



}
