/**
 * BPMN Editor Domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.infrastructure.schema;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;

public class SchemaBean implements IsSerializable{

	private String targetNamespace;
	/**
	 * Actual type in the api : java.net.URI
	 */
	private String documentURI;
	private List<ElementBean> elements;
	private List<SchemaType> types;

	public SchemaBean(){
		super();
		elements = new ArrayList<ElementBean>();
		types = new ArrayList<SchemaType>();
	}
	
	public void addElement(ElementBean e){
		if(elements==null){
			elements = new ArrayList<ElementBean>();
		}
		elements.add(e);
	}

	public void addType(SchemaType t){
		if(types==null){
			types = new ArrayList<SchemaType>();
		}
		types.add(t);
	}

	public SchemaType getType(String typeName){
		SchemaType result = null;
		if(types!=null){
			int i = 0;
			boolean found = false;
			while(i<types.size() && !found){
				SchemaType t = types.get(i);
				if(t.getName().equals(typeName)){
					result = t;
					found = true;
				}
				else{
					i++;
				}
			}
		}
		return result;
	}

	public ElementBean getElement(String elementName){
		ElementBean result = null;
		int i = 0;
		boolean found = false;
		while(i<elements.size() && !found){
			ElementBean e = elements.get(i);
			if(e.getqName().equals(elementName)){
				result = e;
				found = true;
			}
			else{
				i++;
			}
		}
		return result;
	}
	////////////////////////////////////////////
	/////                                  /////
	/////       GETTERS AND SETTERS        /////
	/////                                  /////
	////////////////////////////////////////////
	public String getTargetNamespace() {
		return targetNamespace;
	}
	public void setTargetNamespace(String targetNamespace) {
		this.targetNamespace = targetNamespace;
	}
	public String getDocumentURI() {
		return documentURI;
	}
	public void setDocumentURI(String documentURI) {
		this.documentURI = documentURI;
	}
	public List<ElementBean> getElements() {
		return elements;
	}
	public void setElements(List<ElementBean> elements) {
		this.elements = elements;
	}
	public List<SchemaType> getTypes() {
		return types;
	}
	public void setTypes(List<SchemaType> types) {
		this.types = types;
	}

}
