/**
 * BPMN Editor Domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.Constants.ProcessTypes;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.collaboration.LaneBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.collaboration.LaneSetBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.common.FlowNodeBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.foundation.BaseElementBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.activity.TaskBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.event.EndEventBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.event.StartEventBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.gateway.GatewayBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.gateway.SequenceFlowBean;



public class ProcessBean extends BaseElementBean {

	private String name;
	/**
	 * Actual type in the api : com.ebmwebsourcing.easybpmn.model.bpmn.jaxb.TProcessType
	 */
	private ProcessTypes type;
	private List<LaneSetBean> laneSets;

	public ProcessBean(){
		super();
		laneSets = new ArrayList<LaneSetBean>();
		type = ProcessTypes.NONE;
		name = "";
	}
	
	public ProcessBean(String id){
		super(id);
		type = ProcessTypes.NONE;
		name = "";
	}
	
	public void addLaneSet(LaneSetBean lsb){
		if(laneSets==null){
			laneSets = new ArrayList<LaneSetBean>();
		}
		laneSets.add(lsb);
	}
	////////////////////////////////////////////
	/////                                  /////
	/////       GETTERS AND SETTERS        /////
	/////                                  /////
	////////////////////////////////////////////	
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}

	public List<LaneSetBean> getLaneSets() {
		return laneSets;
	}
	public void setLaneSets(List<LaneSetBean> laneSets) {
		this.laneSets = laneSets;
	}
	public ProcessTypes getType() {
		return type;
	}
	public void setType(ProcessTypes type) {
		this.type = type;
	}
	public List<? extends FlowNodeBean> getFlowNodes() {
		List<FlowNodeBean> nodes = null;
		if(laneSets!=null && laneSets.size()>0){
			nodes = new ArrayList<FlowNodeBean>();
			for(LaneSetBean ls : laneSets){
				List<LaneBean> lanes = ls.getLanes();
				if(lanes!=null && lanes.size()>0){
					for(LaneBean lane : lanes){
						nodes.addAll(lane.getEndEvents());
						nodes.addAll(lane.getStartEvents());
						nodes.addAll(lane.getTasks());
					}
				}
			}
		}
		return nodes;
	}

	public List<StartEventBean> getStartEvents(){
		List<StartEventBean> nodes = null;
		if(laneSets!=null && laneSets.size()>0){
			nodes = new ArrayList<StartEventBean>();
			for(LaneSetBean ls : laneSets){
				List<LaneBean> lanes = ls.getLanes();
				if(lanes!=null && lanes.size()>0){
					for(LaneBean lane : lanes){
						nodes.addAll(lane.getStartEvents());
					}
				}
			}
		}
		return nodes;
	}

	public List<EndEventBean> getEndEvents(){
		List<EndEventBean> nodes = null;
		if(laneSets!=null && laneSets.size()>0){
			nodes = new ArrayList<EndEventBean>();
			for(LaneSetBean ls : laneSets){
				List<LaneBean> lanes = ls.getLanes();
				if(lanes!=null && lanes.size()>0){
					for(LaneBean lane : lanes){
						nodes.addAll(lane.getEndEvents());
					}
				}
			}
		}
		return nodes;
	}

	public List<GatewayBean> getGateways(){
		List<GatewayBean> tasks = null;
		if(laneSets!=null && laneSets.size()>0){
			tasks = new ArrayList<GatewayBean>();
			for(LaneSetBean ls : laneSets){
				List<LaneBean> lanes = ls.getLanes();
				if(lanes!=null && lanes.size()>0){
					for(LaneBean lane : lanes){
						tasks.addAll(lane.getGateways());
					}
				}
			}
		}
		return tasks;
	}

	public List<TaskBean> getTasks(){
		List<TaskBean> nodes = null;
		if(laneSets!=null && laneSets.size()>0){
			nodes = new ArrayList<TaskBean>();
			for(LaneSetBean ls : laneSets){
				List<LaneBean> lanes = ls.getLanes();
				if(lanes!=null && lanes.size()>0){
					for(LaneBean lane : lanes){
						nodes.addAll(lane.getTasks());
					}
				}
			}
		}
		return nodes;
	}

	public List<SequenceFlowBean> getSequenceFlows(){
		List<SequenceFlowBean> sequenceFlows = null;
		if(laneSets!=null && laneSets.size()>0){
			for(LaneSetBean ls : laneSets){
				sequenceFlows = new ArrayList<SequenceFlowBean>();
				List<LaneBean> lanes = ls.getLanes();
				if(lanes!=null && lanes.size()>0){
					for(LaneBean lane : lanes){
						sequenceFlows.addAll(lane.getSequenceFlows());
					}
				}
			}
		}
		return sequenceFlows;
	}

}
