/**
 * BPMN Editor Domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.activity;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.common.FlowNodeBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.data.DataInputAssociationBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.data.DataOutputAssociationBean;


public class ActivityBean extends FlowNodeBean{

	private List<DataInputAssociationBean> dataInputAssociations;
	private List<DataOutputAssociationBean> dataOutputAssociations;
	
	public ActivityBean(String id){
		super(id);
	}
	
	public ActivityBean(){
		super();
		dataInputAssociations = new ArrayList<DataInputAssociationBean>();
		dataOutputAssociations = new ArrayList<DataOutputAssociationBean>();
	}
	
	public void addDataInputAssociation(DataInputAssociationBean dia){
		if(dataInputAssociations==null){
			dataInputAssociations = new ArrayList<DataInputAssociationBean>();
		}
		dataInputAssociations.add(dia);
	}
	
	public void addDataOutputAssociation(DataOutputAssociationBean doa){
		if(dataOutputAssociations==null){
			dataOutputAssociations = new ArrayList<DataOutputAssociationBean>();
		}
		dataOutputAssociations.add(doa);
	}
	////////////////////////////////////////////
	/////                                  /////
	/////       GETTERS AND SETTERS        /////
	/////                                  /////
	////////////////////////////////////////////
	public List<DataInputAssociationBean> getDataInputAssociations() {
		return dataInputAssociations;
	}
	public void setDataInputAssociations(
			List<DataInputAssociationBean> dataInputAssociations) {
		this.dataInputAssociations = dataInputAssociations;
	}
	public List<DataOutputAssociationBean> getDataOutputAssociations() {
		return dataOutputAssociations;
	}
	public void setDataOutputAssociations(
			List<DataOutputAssociationBean> dataOutputAssociations) {
		this.dataOutputAssociations = dataOutputAssociations;
	}
}
