/**
 * BPMN Editor Domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.activity;


import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.Constants.TaskType;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.common.MessageBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.service.OperationBean;

public class ReceiveTaskBean extends TaskBean {

	private boolean instanciate;
	private MessageBean message;
	private OperationBean operation;
	
	public ReceiveTaskBean(String id){
		super(id);
		this.setTaskType(TaskType.RECEIVE_TASK);
		this.message = null;
		this.operation = null;
	}
	
	public ReceiveTaskBean(){
		super();
		this.setTaskType(TaskType.RECEIVE_TASK);
	}
	////////////////////////////////////////////
	/////                                  /////
	/////       GETTERS AND SETTERS        /////
	/////                                  /////
	////////////////////////////////////////////
	public boolean isInstanciate() {
		return instanciate;
	}
	public void setInstanciate(boolean instanciate) {
		this.instanciate = instanciate;
	}
	public MessageBean getMessage() {
		return message;
	}
	public void setMessage(MessageBean message) {
		this.message = message;
	}
	public OperationBean getOperation() {
		return operation;
	}
	public void setOperation(OperationBean operation) {
		this.operation = operation;
	}
	
}
