/**
 * BPMN Editor Domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.activity;


import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.Constants.TaskType;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.service.OperationBean;

public class ServiceTaskBean extends TaskBean {

	private String serviceName;
	private OperationBean operation;
	
	public ServiceTaskBean(String id){
		super(id);
		this.setTaskType(TaskType.SERVICE_TASK);
		this.serviceName = null;
		this.operation = null;
	}
	
	public ServiceTaskBean(){
		super();
		this.setTaskType(TaskType.SERVICE_TASK);
	}
	////////////////////////////////////////////
	/////                                  /////
	/////       GETTERS AND SETTERS        /////
	/////                                  /////
	////////////////////////////////////////////
	public String getServiceName() {
		return serviceName;
	}
	public void setServiceName(String serviceName) {
		this.serviceName = serviceName;
	}
	public OperationBean getOperation() {
		return operation;
	}
	public void setOperation(OperationBean operation) {
		this.operation = operation;
	}
	
}
