/**
 * BPMN Editor Domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.gateway;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.Constants.GatewayType;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.common.FlowElementBean;




public abstract class GatewayBean extends FlowElementBean{
	
	private List<FlowElementBean> incomingActivities;
	private List<FlowElementBean> outgoingActivities;

	private GatewayType gatewayType;
	
	public GatewayBean(String id){
		super(id);
	}
	
	public GatewayBean(){
		super();
		incomingActivities = new ArrayList<FlowElementBean>();
		outgoingActivities = new ArrayList<FlowElementBean>();
	}
	
	public void addIncomingActivity(FlowElementBean feb){
		if(incomingActivities==null){
			incomingActivities = new ArrayList<FlowElementBean>();
		}
		incomingActivities.add(feb);
	}
	
	public void addOutgoingActivity(FlowElementBean feb){
		if(outgoingActivities==null){
			outgoingActivities = new ArrayList<FlowElementBean>();
		}
		outgoingActivities.add(feb);
	}
	////////////////////////////////////////////
	/////                                  /////
	/////       GETTERS AND SETTERS        /////
	/////                                  /////
	////////////////////////////////////////////
	public GatewayType getGatewayType() {
		return gatewayType;
	}
	protected void setGatewayType(GatewayType gatewayType) {
		this.gatewayType = gatewayType;
	}
	public List<FlowElementBean> getIncomingActivities() {
		return incomingActivities;
	}
	public void setIncomingActivities(List<FlowElementBean> incomingActivities) {
		this.incomingActivities = incomingActivities;
	}
	public List<FlowElementBean> getOutgoingActivities() {
		return outgoingActivities;
	}
	public void setOutgoingActivities(List<FlowElementBean> outgoingActivities) {
		this.outgoingActivities = outgoingActivities;
	}
	
}
