/**
 * BPMN Editor Domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.service;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.common.MessageBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.foundation.BaseElementBean;



public class OperationBean extends BaseElementBean{
	private String name;
	private MessageBean messageIn;
	private MessageBean messageOut;
	private List<MessageBean> errorMessages;
	
	public OperationBean(String id){
		super(id);
	}
	
	public OperationBean(){
		super();
		errorMessages = new ArrayList<MessageBean>();
	}
	
	public void addErrorMessage(MessageBean msg){
		if(errorMessages==null){
			errorMessages = new ArrayList<MessageBean>();
		}
		errorMessages.add(msg);
	}
	////////////////////////////////////////////
	/////                                  /////
	/////       GETTERS AND SETTERS        /////
	/////                                  /////
	////////////////////////////////////////////
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public MessageBean getMessageIn() {
		return messageIn;
	}
	public void setMessageIn(MessageBean messageIn) {
		this.messageIn = messageIn;
	}
	public MessageBean getMessageOut() {
		return messageOut;
	}
	public void setMessageOut(MessageBean messageOut) {
		this.messageOut = messageOut;
	}
	public List<MessageBean> getErrorMessages() {
		return errorMessages;
	}
	public void setErrorMessages(List<MessageBean> errorMasseges) {
		this.errorMessages = errorMasseges;
	}
	
}
