/**
 * BPMN Editor Domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.business.service.bpmn2.to.clientToServer;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.List;

import javax.xml.namespace.QName;

import org.ow2.easywsdl.schema.DefaultSchemaImpl;
import org.ow2.easywsdl.schema.SchemaFactory;
import org.ow2.easywsdl.schema.api.ComplexType;
import org.ow2.easywsdl.schema.api.Documentation;
import org.ow2.easywsdl.schema.api.Element;
import org.ow2.easywsdl.schema.api.Enumeration;
import org.ow2.easywsdl.schema.api.Restriction;
import org.ow2.easywsdl.schema.api.Schema;
import org.ow2.easywsdl.schema.api.Sequence;
import org.ow2.easywsdl.schema.api.SimpleType;
import org.ow2.easywsdl.schema.api.Type;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.ModelVisitor;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.Constants.ItemKind;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.Constants.ProcessTypes;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.collaboration.CollaborationBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.collaboration.LaneBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.collaboration.LaneSetBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.collaboration.PoolBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.common.FlowNodeBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.common.ItemDefinitionBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.common.MessageBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.common.MessageFlowBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.common.ParticipantBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.common.PartnerRoleBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.foundation.BPMNElementBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.infrastructure.DefinitionsBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.infrastructure.ImportBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.infrastructure.schema.BasicType;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.infrastructure.schema.ElementBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.infrastructure.schema.RestrictionBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.infrastructure.schema.SchemaBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.infrastructure.schema.SchemaType;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.infrastructure.schema.SequenceBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.ProcessBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.activity.ReceiveTaskBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.activity.SendTaskBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.activity.ServiceTaskBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.activity.TaskBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.data.AssignementBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.data.DataInputAssociationBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.data.DataOutputAssociationBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.event.EndEventBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.event.StartEventBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.event.definition.EventDefinitionBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.event.definition.MessageEventDefinitionBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.gateway.ExclusiveGatewayBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.gateway.GatewayBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.gateway.ParallelGatewayBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.gateway.SequenceFlowBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.service.InterfaceBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.service.OperationBean;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.BPMNElement;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.collaboration.Collaboration;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.collaboration.Lane;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.collaboration.LaneSet;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.collaboration.Pool;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.common.FlowElement;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.common.FlowNode;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.common.ItemDefinition;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.common.Message;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.common.MessageFlow;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.common.Participant;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.common.PartnerRole;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.infrastructure.Definitions;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.infrastructure.Import;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.process.Process;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.process.activity.ReceiveTask;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.process.activity.SendTask;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.process.activity.ServiceTask;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.process.activity.Task;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.process.data.Assignement;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.process.data.DataInputAssociation;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.process.data.DataOutputAssociation;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.process.data.Expression;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.process.event.EndEvent;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.process.event.StartEvent;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.process.event.definition.EventDefinition;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.process.event.definition.MessageEventDefinition;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.process.gateway.ExclusiveGateway;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.process.gateway.Gateway;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.process.gateway.ParallelGateway;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.process.gateway.SequenceFlow;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.service.Interface;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.service.Operation;
import com.ebmwebsourcing.easybpmn.model.bpmn.impl.BPMNFactoryImpl;
import com.ebmwebsourcing.easybpmn.model.bpmn.impl.standard.infrastructure.ImportImpl;
import com.ebmwebsourcing.easybpmn.model.bpmn.jaxb.TItemKind;
import com.ebmwebsourcing.easybpmn.model.bpmn.jaxb.TProcessType;

public class BeanModelAdapter extends ModelVisitor{
	
	private String storageAddress;

	private Import currentImport;
	private Definitions defs;
	private Message currentMessage;
	private ItemDefinition currentItemDefiniton;
	private Interface currentInterface;
	private Operation currentOperation;
	private Process currentProcess;
	private LaneSet currentLaneSet;
	private Lane currentLane;
	private Collaboration currentCollaboration;
	private MessageFlow currentMessageFlow;
	private Pool currentPool;
	private Participant currentParticipant;
	
	public BeanModelAdapter(DefinitionsBean defs, String xmlPath) throws Exception{
		 super(defs);
		 this.storageAddress = xmlPath;
	}
	
	public Definitions getDefinitions(){
		return this.defs;
	}
	
	@Override	
	public void visitDefinitions(DefinitionsBean defsBean) throws Exception{
		defs = BPMNFactoryImpl.getInstance().newBPMNDefinitions();
		
		defs.setId(defsBean.getId());
		setDocumentation(defs, defsBean);
		defs.setTargetNamespace(defsBean.getTargetNamespace());
		defs.setTypeLanguage(defsBean.getTypeLanguage());
		defs.setExpressionLanguage(defsBean.getExpressionLanguage());
	}
	
	@Override
	public void visitImport(ImportBean importBean) throws Exception{
		Import i = defs.newImport();
		setDocumentation(i, importBean);
		i.setImportType(new URI(importBean.getImportType()));
		i.setLocation(new URI(importBean.getLocation()));
		i.setNamespace(new URI(importBean.getNamespace()));
		defs.addImport(i);
		
		Schema s = SchemaFactory.newInstance().newSchemaReader().read(new URL("file://"+storageAddress+i.getLocation().toString()));
		((ImportImpl)i).setSchema(s);
		
		currentImport = i;
	}
	
//	@Override
//	public void visitSchema(SchemaBean sb) throws Exception{
//		Schema s = SchemaFactory.newInstance().newSchema();
//		s.setTargetNamespace(sb.getTargetNamespace());
//		s.setDocumentURI(new URI(sb.getDocumentURI()));
//		((ImportImpl)currentImport).setSchema(s);
//	}
//	
//	@Override
//	public void visitSchemaType(SchemaType type) {
//		Schema s = currentImport.getSchema();
//		
//		if(type instanceof SequenceBean){
//			SequenceBean sequenceBean = (SequenceBean) type;
//			ComplexType complexType = (ComplexType) s.createComplexType();
//			complexType.setQName(new QName(s.getTargetNamespace(),sequenceBean.getName()));
//			s.addType(complexType);
//		}
//		else{//restriction
//			RestrictionBean restrictionBean = (RestrictionBean) type;
//			final SimpleType st = (SimpleType) s.createSimpleType();
//	        st.setQName(new QName(s.getTargetNamespace(), restrictionBean.getName()));
//	        final Restriction rest = st.createRestriction();
//	        rest.setBase(SchemaFactory.getDefaultSchema().getTypeString().getQName());
//	        for(String enumerationValue : restrictionBean.getValues()){
//	        	Enumeration enum1 = rest.createEnumeration(); 
//	        	enum1.setValue(enumerationValue);
//	        	rest.addEnumeration(enum1);
//	        }
//	        s.addType(st);
//		}
//	}
//	
//	@Override
//	public void finalizeTypes(SchemaBean schema) {
//		Schema s = currentImport.getSchema();
//		
//		for(SchemaType type : schema.getTypes()){
//			if(type instanceof SequenceBean){
//				SequenceBean sequenceBean = (SequenceBean) type;
//				ComplexType ct = (ComplexType) s.getType(new QName(s.getTargetNamespace(),type.getName()));
//				Sequence seq = ct.createSequence();
//				ct.setSequence(seq);
//				for(ElementBean elementBean : sequenceBean.getElements()){
//					Element element = seq.createElement();
//					element.setQName(new QName(s.getTargetNamespace(),elementBean.getqName()));
//					setType(element, elementBean.getType(), s);//This implies that only already defined types can be used
//					seq.addElement(element);
//				}
//			}
//		}
//	}
//	
//	@Override
//	public void visitElementBean(ElementBean eb) {
//		Schema s = currentImport.getSchema();
//		
//		Element element = s.createElement();
//		element.setQName(new QName(s.getTargetNamespace(),eb.getqName()));
//		setType(element, eb.getType(),s);
//		s.addElement(element);
//	}
	
	@Override
	public void visitMessage(MessageBean messageBean) {
		Message msg = defs.newMessage();
		setDocumentation(msg, messageBean);
		msg.setId(messageBean.getId());
		msg.setName(messageBean.getName());
		defs.addMessage(msg);
		
		currentMessage = msg;
	}
	
	@Override
	public void visitItemDefinition(ItemDefinitionBean idb) {
		ItemDefinition id = currentMessage.newItemDefinition();
		id.setCollection(idb.isCollection());
		setDocumentation(id, idb);
		id.setId(idb.getId());
		id.setItemKind(retrieveItemKind(idb.getItemKind()));
		currentMessage.setItemDefinition(id);
		
		currentItemDefiniton = id;
	}
	
	@Override
	public void visitItemDefinitionElement(ElementBean element,ItemDefinitionBean idb) {
		Schema s = null;
		String targetNamespace = idb.getElement().getSchemaTargetNamespace();
		for(Import i : defs.getImports()){
			if(i.getSchema().getTargetNamespace().equals(targetNamespace)){
				s = i.getSchema();
			}
		}
		currentItemDefiniton.setElement(s.getElement(new QName(s.getTargetNamespace(),idb.getElement().getqName())));
	}
	
	@Override
	public void visitPartnerRole(PartnerRoleBean prBean) {
		PartnerRole pr = defs.newPartnerRole();
		pr.setId(prBean.getId());
		setDocumentation(pr, prBean);
		pr.setName(prBean.getName());
		defs.addPartnerRole(pr);
	}
	
	@Override
	public void visitInterface(InterfaceBean itfBean) {
		Interface itf = defs.newInterface();
		setDocumentation(itf, itfBean);
		itf.setId(itfBean.getId());
		itf.setName(itfBean.getName());
		defs.addInterface(itf);
		
		currentInterface = itf;
	}
	
	@Override
	public void visitOperation(OperationBean opBean) {
		Operation op = currentInterface.newOperation();
		setDocumentation(op, opBean);
		op.setName(opBean.getName());
		op.setId(opBean.getId());
		currentInterface.addOperation(op);
		
		currentOperation = op;
	}
	
	@Override
	public void visitOperationMessageIn(MessageBean msg, OperationBean opBean) {
		currentOperation.setMessageIn(findMessage(msg.getId()));
	}
	
	@Override
	public void visitOperationMessageOut(MessageBean msg, OperationBean opBean) {
		currentOperation.setMessageOut(findMessage(msg.getId()));
	}
	
	@Override
	public void visitOperationErrorMessage(MessageBean msg, OperationBean opBean) {
		currentOperation.addErrorMessage(findMessage(msg.getId()));
	}
	
	@Override
	public void visitProcess(ProcessBean processBean) {
		Process process = defs.newProcess();
		setDocumentation(process,processBean);
		process.setId(processBean.getId());
		process.setName(processBean.getName());
		process.setProcessType(retrieveProcessType(processBean.getType()));
		defs.addProcess(process);
		
		currentProcess = process;
	}
	
	@Override
	public void visitLaneSet(LaneSetBean laneSetBean) {
		LaneSet laneSet = currentProcess.newLaneSet();
		currentProcess.addLaneSet(laneSet);
		laneSet.setId(laneSetBean.getId());
		setDocumentation(laneSet, laneSetBean);
		
		currentLaneSet = laneSet;
	}
	
	@Override
	public void visitLane(LaneBean laneBean) {
		Lane lane = currentLaneSet.newLane();
		currentLaneSet.addLane(lane);
		setDocumentation(lane,laneBean);
		lane.setName(laneBean.getName());
		lane.setId(laneBean.getId());
		
		currentLane = lane;
	}
	
	@Override
	public void visitChildLaneSet(LaneSetBean lsb) {
		LaneSet laneSet = currentProcess.newLaneSet();
		currentLane.setChildLaneSet(laneSet);
		laneSet.setId(lsb.getId());
		setDocumentation(laneSet, lsb);
		
		parseLaneSet(lsb);
	}
	
	@Override
	public void visitStartEvent(StartEventBean seb) {
		StartEvent startEvent = currentLane.newStartEvent();
		setDocumentation(startEvent, seb);
		startEvent.setId(seb.getId());
		startEvent.setName(seb.getName());
		if(seb.getTriggers()!=null){
			for(EventDefinitionBean edb : seb.getTriggers()){
				EventDefinition ed = buildEventDefinition(edb, startEvent);
				ed.setId(edb.getId());
				setDocumentation(ed, edb);
				startEvent.addTriggers(ed);
			}
		}
		currentLane.addStartEvent(startEvent);
	}
	
	@Override
	public void visitTask(TaskBean taskBean) {
		if(taskBean.getTaskType()==null){
			adaptSimpleTask(currentLane, taskBean);
		}
		else{
			switch(taskBean.getTaskType()){
			case RECEIVE_TASK:
				adaptReceiveTask(currentLane, (ReceiveTaskBean) taskBean);
				break;
			case SEND_TASK:
				adaptSendTask(currentLane, (SendTaskBean) taskBean);
				break;
			case SERVICE_TASK:
				adaptServiceTask(currentLane, (ServiceTaskBean) taskBean);
				break;
			}
		}
	}
	
	@Override
	public void visitEndEvent(EndEventBean endEventBean) {
		EndEvent endEvent = currentLane.newEndEvent();
		setDocumentation(endEvent, endEventBean);
		endEvent.setName(endEventBean.getName());
		endEvent.setId(endEventBean.getId());
		if(endEventBean.getResults()!=null){
			for(EventDefinitionBean edb : endEventBean.getResults()){
				EventDefinition ed = buildEventDefinition(edb, endEvent);
				ed.setId(edb.getId());
				setDocumentation(ed, edb);
				endEvent.addResults(ed);
			}
		}
		currentLane.addEndEvent(endEvent);
	}
	
	@Override
	public void visitGateway(GatewayBean gb) {
		switch(gb.getGatewayType()){
		case ExclusiveGateway:
			adaptExclusiveGateway(currentLane, (ExclusiveGatewayBean) gb, currentProcess);
			break;
		case ParallelGateway:
			adaptParallelGateway(currentLane, (ParallelGatewayBean) gb);
			break;
		}
	}
	
	@Override
	public void visitSequenceFlow(SequenceFlowBean sequenceFlowBean) {
		SequenceFlow sequenceFlow = currentLane.newSequenceFlow();
		setDocumentation(sequenceFlow, sequenceFlowBean);
		sequenceFlow.setId(sequenceFlowBean.getId());
		
		if(sequenceFlowBean.getExpression()!=null){
			Expression exp = sequenceFlow.newExpression();
			setDocumentation(exp, sequenceFlowBean.getExpression());
			exp.setId(sequenceFlowBean.getExpression().getId());
			exp.setContent(sequenceFlowBean.getExpression().getContent());
			sequenceFlow.setExpression(exp);
		}
		
		FlowElement source = findFlowElementById(currentProcess,sequenceFlowBean.getSourceNode().getId());
		sequenceFlow.setSourceNode(source);
		FlowElement target = findFlowElementById(currentProcess, sequenceFlowBean.getTargetNode().getId());
		sequenceFlow.setTargetNode(target);
		
		currentLane.addSequenceFlow(sequenceFlow);
	}
	
	@Override
	public void visitCollaboration(CollaborationBean cBean) {
		Collaboration c = defs.newCollaboration();
		c.setName(cBean.getName());
		c.setId(cBean.getId());
		setDocumentation(c, cBean);
		defs.addCollaboration(c);
		
		currentCollaboration = c;
	}
	
	@Override
	public void visitMessageFlow(MessageFlowBean msgFlowBean) {
		MessageFlow msgFlow = currentCollaboration.newMessageFlow();
		msgFlow.setId(msgFlowBean.getId());
		msgFlow.setName(msgFlowBean.getName());
		setDocumentation(msgFlow, msgFlowBean);
		currentCollaboration.addMessageFlow(msgFlow);
		currentMessageFlow = msgFlow;
	}
	
	@Override
	public void visitMessageFlowMessage(MessageBean mb) throws Exception{
		String msgId = mb.getId();
		currentMessageFlow.setMessage(findMessage(msgId)); 
	}
	
	@Override
	public void visitMessageFlowSource(FlowNodeBean node) throws Exception{
		FlowNode sourceNode = currentCollaboration.getFlowNode(new QName(defs.getTargetNamespace(),node.getName()));
		currentMessageFlow.setSource(sourceNode);
	}
	
	@Override
	public void visitMessageFlowTarget(FlowNodeBean node) throws Exception{
		FlowNode targetNode = currentCollaboration.getFlowNode(new QName(defs.getTargetNamespace(),node.getName()));
		currentMessageFlow.setTarget(targetNode);
	}
	
	@Override
	public void visitPool(PoolBean pBean) {
		Pool p = currentCollaboration.newPool();
		p.setId(pBean.getId());
		setDocumentation(p, pBean);
		p.setName(pBean.getName());
		currentCollaboration.addPool(p);
		
		currentPool = p;
	}
	
	@Override
	public void visitParticipant(ParticipantBean participantBean) {
		Participant participant = currentPool.newParticipant();
		participant.setId(participantBean.getId());
		setDocumentation(participant, participantBean);
		currentPool.setParticipant(participant);
		
		currentParticipant = participant;
	}
	
	@Override
	public void visitParticipantRole(PartnerRoleBean prBean) {
		currentParticipant.setPartnerRole(defs.getPartnerRole(new QName(defs.getTargetNamespace(),prBean.getName())));
	}
	
	@Override
	public void visitPoolProcess(ProcessBean pBean) {
		currentPool.setProcess(defs.getProcess(new QName(defs.getTargetNamespace(),pBean.getName())));
	}
	
	@Override
	public void visitPoolInterface(InterfaceBean itfBean) {
		currentPool.setInterface(defs.getInterface(new QName(defs.getTargetNamespace(),itfBean.getName())));
	}
	
	private Message findMessage(String msgId){
		for(Message msg : defs.getMessages()){
			if(msg.getId().equals(msgId)){
				return msg;
			}
		}
		return null;
	}
	
//	private Message findMessage(Collaboration c, String msgId) throws BPMNException {
//		if(c.getPools()!=null){
//			for(Pool p : c.getPools()){
//				if(p.getInterface().getOperations()!=null){
//					for(Operation op : p.getInterface().getOperations()){
//						if(op.getMessageIn().getId().equals(msgId)){
//							return op.getMessageIn();
//						}
//						if(op.getMessageOut().getId().equals(msgId)){
//							return op.getMessageOut();
//						}
//					}
//				}
//			}
//		}
//		return null;
//	}
	
	private static FlowElement findFlowElementById(Process process, String id) {
		for(LaneSet laneSet : process.getLaneSets()){
			for(Lane lane : laneSet.getLanes()){
				FlowElement fe = findFlowElementById(lane, id);
				if(fe!=null){
					return fe;
				}
			}
		}
		return null;
	}

	private static FlowElement findFlowElementById(Lane lane, String id) {
		FlowElement result = null;
		int i = 0;
		boolean found = false;
		List<StartEvent> list1 = lane.getStartEvents();
		while(list1!=null && i<list1.size() && !found){
			if(list1.get(i).getId().equals(id)){
				result = list1.get(i);
				found = true;
			}
			else{
				i++;
			}
		}
		i = 0;
		List<EndEvent> list2 = lane.getEndEvents();
		while(list2!=null && i<list2.size() && !found){
			if(list2.get(i).getId().equals(id)){
				result = list2.get(i);
				found = true;
			}
			else{
				i++;
			}
		}
		i = 0;
		List<Task> list3 = lane.getTasks();
		while(list3!=null && i<list3.size() && !found){
			if(list3.get(i).getId().equals(id)){
				result = list3.get(i);
				found = true;
			}
			else{
				i++;
			}
		}
		i = 0;
		List<Gateway> list4 = lane.getGateways();
		while(list4!=null && i<list4.size() && !found){
			if(list4.get(i).getId().equals(id)){
				result = list4.get(i);
				found = true;
			}
			else{
				i++;
			}
		}
		return result;
	}
	
	private void adaptParallelGateway(Lane lane, ParallelGatewayBean gatewayBean) {
		ParallelGateway pg = lane.newParallelGateway();
		setDocumentation(pg, gatewayBean);
		pg.setId(gatewayBean.getId());
		pg.setName(gatewayBean.getName());
		lane.addGateway(pg);
	}

	private void adaptExclusiveGateway(Lane lane, ExclusiveGatewayBean gatewayBean, Process process) {
		ExclusiveGateway eg = lane.newExclusiveGateway();
		setDocumentation(eg, gatewayBean);
		eg.setId(gatewayBean.getId());
		eg.setName(gatewayBean.getName());
		eg.setDefault(findFlowElementById(process, gatewayBean.getId()));
		lane.addGateway(eg);
	}
	
	private void adaptSimpleTask(Lane lane, TaskBean taskBean) {
		Task t = lane.newTask();
		setDocumentation(t, taskBean);
		t.setId(taskBean.getId());
		t.setName(taskBean.getName());
		addDataAssociations(t, taskBean);
		lane.addTask(t);
	}

	private void adaptServiceTask(Lane lane, ServiceTaskBean taskBean) {
		ServiceTask st = lane.newServiceTask();
		setDocumentation(st, taskBean);
		st.setId(taskBean.getId());
		st.setName(taskBean.getName());
		st.setServiceName(new QName(taskBean.getServiceName()));
		if(taskBean.getOperation()!=null){
			st.setOperation(defs.getOperations(new QName(defs.getTargetNamespace(),taskBean.getOperation().getName())).get(0));
		}
		addDataAssociations(st, taskBean);
		lane.addTask(st);
	}

	private void adaptSendTask(Lane lane, SendTaskBean taskBean) {
		SendTask st = lane.newSendTask();
		setDocumentation(st, taskBean);
		st.setId(taskBean.getId());
		st.setName(taskBean.getName());
		if(taskBean.getOperation()!=null){
			st.setOperation(defs.getOperations(new QName(defs.getTargetNamespace(),taskBean.getOperation().getName())).get(0));
		}
		if(taskBean.getMessage()!=null){
			st.setMessage(defs.getMessage(new QName(defs.getTargetNamespace(),taskBean.getMessage().getName())));
		}
		addDataAssociations(st, taskBean);
		lane.addTask(st);
	}

	private void adaptReceiveTask(Lane lane, ReceiveTaskBean taskBean) {
		ReceiveTask rt = lane.newReceiveTask();
		setDocumentation(rt, taskBean);
		rt.setId(taskBean.getId());
		rt.setName(taskBean.getName());
		rt.setInstanctiate(taskBean.isInstanciate());
		if(taskBean.getOperation()!=null){
			rt.setOperation(defs.getOperations(new QName(defs.getTargetNamespace(),taskBean.getOperation().getName())).get(0));
		}
		if(taskBean.getMessage()!=null){
			rt.setMessage(defs.getMessage(new QName(defs.getTargetNamespace(),taskBean.getMessage().getName())));
		}
		addDataAssociations(rt, taskBean);
		lane.addTask(rt);
	}
	
	private void setType(Element element, SchemaType type, Schema s) {
		if(type instanceof BasicType){
			element.setType(retrieveBasicType((BasicType)type));
		}
		else{
			element.setType(s.getType(new QName(s.getTargetNamespace(),type.getName())));
		}
	}
	
	private void addDataAssociations(Task task, TaskBean taskBean){
		List<DataInputAssociationBean> diaBeans = taskBean.getDataInputAssociations();
		if(diaBeans!=null){
			for(DataInputAssociationBean diaBean : diaBeans){
				DataInputAssociation dia = task.newDataInputAssociation();
				setDocumentation(dia, diaBean);
				dia.setId(diaBean.getId());
				for(AssignementBean assignementBean : diaBean.getAssignements()){
					Assignement assignement = dia.newAssignement();
					setDocumentation(assignement, assignementBean);
					assignement.setId(assignementBean.getId());
					assignement.setLanguage(assignementBean.getLanguage());
					buildExpression(assignement, assignementBean);
					dia.addAssignement(assignement);
				}
				task.addDataInputAssociation(dia);
			}
		}
		List<DataOutputAssociationBean> doaBeans = taskBean.getDataOutputAssociations();
		if(doaBeans!=null){
			for(DataOutputAssociationBean doaBean : doaBeans){
				DataOutputAssociation doa = task.newDataOutputAssociation();
				setDocumentation(doa, doaBean);
				doa.setId(doaBean.getId());
				for(AssignementBean ab : doaBean.getAssignements()){
					Assignement a = doa.newAssignement();
					setDocumentation(a, ab);
					a.setId(ab.getId());
					a.setLanguage(ab.getLanguage());
					buildExpression(a, ab);
					doa.addAssignement(a);
				}
				task.addDataOutputAssociation(doa);
			}
		}
	}
	
	private void buildExpression(Assignement a, AssignementBean ab){
		Expression expFrom = a.newExpression();
		setDocumentation(expFrom, ab.getFrom());
		expFrom.setId(ab.getFrom().getId());
		expFrom.setContent(ab.getFrom().getContent());
		Expression expTo = a.newExpression();
		setDocumentation(expTo, ab.getTo());
		expTo.setId(ab.getTo().getId());
		expTo.setContent(ab.getTo().getContent());
		
		a.setFrom(expFrom);
		a.setTo(expTo);
	}
	
	private void setDocumentation(BPMNElement element, BPMNElementBean bean){
		if(bean!=null && bean.getDocumentation()!=null && !bean.getDocumentation().equals("")){
			Documentation doc = element.createDocumentation();
			doc.setContent(bean.getDocumentation());
			element.setDocumentation(doc);
		}
	}
	
	private Type retrieveBasicType(BasicType bt){
		Type result = null;
		if(bt!=null && bt.getType()!=null){
			switch(bt.getType()){
			case BOOLEAN:
				result = DefaultSchemaImpl.getInstance().getTypeBoolean();
				break;
			case DATE:
				result = DefaultSchemaImpl.getInstance().getTypeDateTime();
				break;
			case DOUBLE:
				result = DefaultSchemaImpl.getInstance().getTypeDouble();
				break;
			case FLOAT:
				result = DefaultSchemaImpl.getInstance().getTypeFloat();
				break;
			case INT:
				result = DefaultSchemaImpl.getInstance().getTypeInt();
				break;
			case STRING:
				result = DefaultSchemaImpl.getInstance().getTypeString();
				break;
			default:
				break;
			}
		}
		return result;
	}
	
	private TItemKind retrieveItemKind(ItemKind itemKind) {
		TItemKind result = null;
		if(itemKind!=null){
			switch (itemKind) {
			case INFORMATION:
				result = TItemKind.INFORMATION;
				break;
			case PHYSICAL:
				result = TItemKind.PHYSICAL;
				break;
			default:
				result = null;
				break;
			}
		}
		return result;
	}
	
	private TProcessType retrieveProcessType(ProcessTypes type) {
		TProcessType result = null;
		if(type!=null){
			switch (type) {
			case EXECUTABLE:
				result = TProcessType.EXECUTABLE;
				break;
			case NON_EXECUTABLE:
				result = TProcessType.NON_EXECUTABLE;
				break;
			case NONE:
				result = TProcessType.NONE;
				break;
			case PUBLIC:
				result = TProcessType.PUBLIC;
				break;
			default:
				break;
			}
		}
		return result;
	}
	
	private EventDefinition buildEventDefinition(EventDefinitionBean edb, StartEvent se){
		EventDefinition result = null;
		switch(edb.getType()){
		case MESSAGE_EVENT_DEFINITION:
			result = se.newEventDefinition(EventDefinition.Type.MESSAGE_EVENT_DEFINITION);
			String localpart = ((MessageEventDefinitionBean)edb).getMessageQName();
			if(localpart!=null && !localpart.equals("")){
				QName qname = new QName(defs.getTargetNamespace(), localpart);
				((MessageEventDefinition)result).setMessageQName(qname);
			}
			break;
		default:
			//TODO other cases when they will actually exist
			break;	
		}
		return result;
	}
	
	private EventDefinition buildEventDefinition(EventDefinitionBean edb, EndEvent ee){
		EventDefinition result = null;
		switch(edb.getType()){
		case MESSAGE_EVENT_DEFINITION:
			result = ee.newEventDefinition(EventDefinition.Type.MESSAGE_EVENT_DEFINITION);
			String localpart = ((MessageEventDefinitionBean)edb).getMessageQName();
			if(localpart!=null && !localpart.equals("")){
				QName qname = new QName(defs.getTargetNamespace(), localpart);
				((MessageEventDefinition)result).setMessageQName(qname);
			}
			break;
		default:
			//TODO other cases when they will actually exist
			break;	
		}
		return result;
	}
	
//	private EventDefinition.Type retrieveEventType(EventDefinitionType edt) {
//		EventDefinition.Type result = null;
//		if(edt!=null){
//			switch (edt) {
//			case CANCEL_EVENT_DEFINITION:
//				result = EventDefinition.Type.CANCEL_EVENT_DEFINITION;
//				break;
//			case COMPENSATE_EVENT_DEFINITION:
//				result = EventDefinition.Type.COMPENSATE_EVENT_DEFINITION;
//				break;
//			case CONDITIONAL_EVENT_DEFINITION:
//				result = EventDefinition.Type.CONDITIONAL_EVENT_DEFINITION;
//				break;
//			case ERROR_EVENT_DEFINITION:
//				result = EventDefinition.Type.ERROR_EVENT_DEFINITION;
//				break;
//			case ESCALATION_EVENT_DEFINITION:
//				result = EventDefinition.Type.ESCALATION_EVENT_DEFINITION;
//				break;
//			case LINK_EVENT_DEFINITION:
//				result = EventDefinition.Type.LINK_EVENT_DEFINITION;
//				break;
//			case MESSAGE_EVENT_DEFINITION:
//				result = EventDefinition.Type.MESSAGE_EVENT_DEFINITION;
//				break;
//			case SIGNAL_EVENT_DEFINITION:
//				result = EventDefinition.Type.SIGNAL_EVENT_DEFINITION;
//				break;
//			case TERMINATE_EVENT_DEFINITION:
//				result = EventDefinition.Type.TERMINATE_EVENT_DEFINITION;
//				break;
//			case TIMER_EVENT_DEFINITION:
//				result = EventDefinition.Type.TIMER_EVENT_DEFINITION;
//				break;
//			default:
//				break;
//			}
//		}
//		return result;
//	}
}
