/**
 * BPMN Editor Domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.business.service.bpmn2.to.clientToServer;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.infrastructure.DefinitionsBean;
import com.ebmwebsourcing.bpmneditor.business.service.bpmn2.to.clientToServer.xmlWriting.XMLWriter;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.infrastructure.Definitions;

public class ClientToServer {

	
	public static Definitions adapt(DefinitionsBean def, boolean xmlStorage, String xmlPath) throws Exception{
		new ClientToServer();
		
		BeanModelAdapter adapter = new BeanModelAdapter(def,xmlPath);
		adapter.visitDefinitionsByLists();
		
		if(xmlStorage){
			new XMLWriter(def,xmlPath);
		}
		
		return adapter.getDefinitions();
	}
	
	
}
