/**
 * BPMN Editor Domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.business.service.bpmn2.to.clientToServer.xmlWriting;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.ModelVisitor;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.collaboration.LaneBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.collaboration.PoolBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.common.MessageFlowBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.foundation.GraphicElementBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.infrastructure.DefinitionsBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.activity.TaskBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.event.EndEventBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.event.StartEventBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.gateway.GatewayBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.gateway.SequenceFlowBean;


public class XMLWriter extends ModelVisitor{
	private String path;

	private DefinitionsBean definitions;
	private FileOutputStream fos;

	public XMLWriter(DefinitionsBean definitions, String xmlPath) throws Exception{
		super(definitions);
		this.definitions = definitions;
		this.path = xmlPath;
		
		this.init();
		
		this.visitDefinitionsByLists();
		
		this.close();
	}
	
	private void init(){
		buildDirectory();

		File file = new File(path+definitions.getId()+".xml");

		if(!file.exists()){
			try {
				file.createNewFile();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		file.setWritable(true);
		try {
			fos = new FileOutputStream(file);
			String xmlHeader =  "<?xml version=\"1.0\"?>\n";
			xmlHeader += "<DEF"+definitions.getId()+">\n";
			fos.write(xmlHeader.getBytes());
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	private void buildDirectory() {
		File file = new File(path);
		if(!file.exists()){
			file.mkdir();
		}
	}

	private void close(){
		try{
			String end = "</DEF"+definitions.getId()+">\n";
			fos.write(end.getBytes());
			fos.close();
		}
		catch(Exception e){
			e.printStackTrace();
		}
	}

	private void savePosition(GraphicElementBean geb){
		String tag = "GI"+geb.getId();
		String s = "<"+tag+">\n";
		s += "\t<xright>"+geb.getX_right()+"</xright>\n";
		s += "\t<xleft>"+geb.getX_left()+"</xleft>\n";
		s += "\t<yright>"+geb.getY_right()+"</yright>\n";
		s += "\t<yleft>"+geb.getY_left()+"</yleft>\n";
		s += "</"+tag+">\n";
		try {
			fos.write(s.getBytes());
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
	public void visitPool(PoolBean pool) {
		savePosition(pool);
	}
	public void visitMessageFlow(MessageFlowBean mfb) {
		savePosition(mfb);
	}
	public void visitSequenceFlow(SequenceFlowBean sfb) {
		savePosition(sfb);
	}
	public void visitGateway(GatewayBean gb) {
		savePosition(gb);
	}
	public void visitEndEvent(EndEventBean eeb) {
		savePosition(eeb);
	}
	public void visitTask(TaskBean tb) {
		savePosition(tb);
	}
	public void visitStartEvent(StartEventBean seb) {
		savePosition(seb);
	}
	public void visitLane(LaneBean lane) {
		savePosition(lane);
	}
}
