/**
 * BPMN Editor Domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.business.service.bpmn2.to.serverToClient.xmlParsing;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.foundation.GraphicElementBean;



public class GraphicalInformation {
	private String path;
	
	private String definitionsId;
	private Map<String,GraphicalDescription> info;
	
	public GraphicalInformation(String definitionsId, String xmlPath){
		this.info = new HashMap<String, GraphicalDescription>();
		this.definitionsId = definitionsId;
		this.path = xmlPath;
		retrieveInformation();
	}
	
	private void retrieveInformation(){
		try{
			SAXParserFactory factory = SAXParserFactory.newInstance();

			SAXParser parser = factory.newSAXParser();

			File file = new File(path+definitionsId+".xml");
			DefaultHandler handler = new MyHandler(info);
			parser.parse(file, handler);

		}
		catch(ParserConfigurationException pce){pce.printStackTrace();}
		catch(SAXException se){se.printStackTrace();}
		catch(FileNotFoundException fnfe){}//TODO beware : may have to changed
		catch(IOException ioe){ioe.printStackTrace();}
	}

	public void setGraphicalInfo(GraphicElementBean geb){
		GraphicalDescription gd = info.get(geb.getId());
		if(gd!=null){
			geb.setX_left(gd.getX_left());
			geb.setX_right(gd.getX_right());
			geb.setY_left(gd.getY_left());
			geb.setY_right(gd.getY_rigth());
		}
	}
}
