/**
 * BPMN Editor Domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.business.service.bpmn2.to.serverToClient.xmlParsing;

import java.util.Map;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MyHandler extends DefaultHandler{
	private Map<String, GraphicalDescription> info;
	private GraphicalDescription gd;
	private boolean xr,xl,yr,yl;
	
	public MyHandler(Map<String, GraphicalDescription> info){
		this.info = info;
		this.gd = null;
		this.xr = false;
		this.xl = false;
		this.yr = false;
		this.yl = false;
	}
	
	public void startElement(String uri, String localName,String qName, Attributes attributes) throws SAXException{
		if(qName.equals("xright")){
			xr = true;
		}
		else if(qName.equals("yright")){
			yr = true;
		}
		else if(qName.equals("xleft")){
			xl = true;
		}
		else if(qName.equals("yleft")){
			yl = true;
		}
		else{
			GraphicalDescription desc = new GraphicalDescription();
			info.put(qName.substring(2), desc);
			gd = desc;
		}
	}
	
	public void endElement(String uri, String localName, String qName) throws SAXException{
		if(qName.equals("xright")){
			xr = false;
		}
		else if(qName.equals("yright")){
			yr = false;
		}
		else if(qName.equals("xleft")){
			xl = false;
		}
		else if(qName.equals("yleft")){
			yl = false;
		}
		else{
			gd = null;
		}
	}
	
	public void characters(char[] ch,int start, int length) throws SAXException{
		if(xr){
			int i = Integer.valueOf(new String(ch,start,length));
			gd.setX_right(i);
		}
		else if(xl){
			int i = Integer.valueOf(new String(ch,start,length));
			gd.setX_left(i);
		}
		else if(yr){
			int i = Integer.valueOf(new String(ch,start,length));
			gd.setY_rigth(i);
		}
		else if(yl){
			int i = Integer.valueOf(new String(ch,start,length));
			gd.setY_left(i);
		}
	}
}
