/**
 * BPMN Editor Collaborative client - A collaboration platform client for the BPMN Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.collaboration.comet.client;


import java.util.List;

import com.ebmwebsourcing.bpmneditor.collaboration.comet.client.editor.CometStandAloneBPMNEditor;
import com.ebmwebsourcing.bpmneditor.collaboration.comet.client.event.NewCollaborationEvent;
import com.ebmwebsourcing.bpmneditor.collaboration.comet.client.event.ServiceEvent;
import com.ebmwebsourcing.bpmneditor.collaboration.comet.client.event.UserJoinedCollaborationEvent;
import com.ebmwebsourcing.bpmneditor.collaboration.comet.client.event.UserLeftCollaborationEvent;
import com.ebmwebsourcing.bpmneditor.collaboration.comet.client.service.DeltaService;
import com.ebmwebsourcing.bpmneditor.collaboration.comet.client.service.DeltaServiceAsync;
import com.ebmwebsourcing.bpmneditor.collaboration.comet.client.to.CollaborationStatus;
import com.ebmwebsourcing.bpmneditor.collaboration.comet.client.ui.CollaborationsTreePanel;
import com.ebmwebsourcing.bpmneditor.collaboration.comet.client.ui.GroupsTreePanel;
import com.ebmwebsourcing.bpmneditor.collaboration.comet.client.user.Collaboration;
import com.ebmwebsourcing.bpmneditor.collaboration.comet.client.user.User;
import com.ebmwebsourcing.bpmneditor.collaboration.comet.client.user.UserGroup;
import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.gwtext.client.core.EventObject;
import com.gwtext.client.core.RegionPosition;
import com.gwtext.client.widgets.Button;
import com.gwtext.client.widgets.MessageBox;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.Viewport;
import com.gwtext.client.widgets.MessageBox.ConfirmCallback;
import com.gwtext.client.widgets.event.ButtonListenerAdapter;
import com.gwtext.client.widgets.form.Label;
import com.gwtext.client.widgets.form.TextField;
import com.gwtext.client.widgets.layout.AnchorLayout;
import com.gwtext.client.widgets.layout.AnchorLayoutData;
import com.gwtext.client.widgets.layout.BorderLayout;
import com.gwtext.client.widgets.layout.BorderLayoutData;
import com.gwtext.client.widgets.layout.FitLayout;
import com.gwtext.client.widgets.layout.VerticalLayout;

import de.novanic.eventservice.client.event.Event;
import de.novanic.eventservice.client.event.RemoteEventService;
import de.novanic.eventservice.client.event.RemoteEventServiceFactory;
import de.novanic.eventservice.client.event.domain.DomainFactory;
import de.novanic.eventservice.client.event.listener.RemoteEventListener;

public class CometEntryPoint implements EntryPoint{
	
	private CollaborationStatus status;
	private String id;
	private User me;
	
	private GroupsTreePanel westPanel;
	private CollaborationsTreePanel eastPanel;
	private Panel creationPanel;
	
	private final DeltaServiceAsync deltaService = GWT.create(DeltaService.class);
	private RemoteEventService remoteEventService;
	
	
	
	public void onModuleLoad() {

		Panel panel = new Panel();  
		panel.setBorder(false);  
		panel.setLayout(new FitLayout());
		

		Panel borderPanel = new Panel();
		borderPanel.setLayout(new BorderLayout());
		
		
		westPanel = new GroupsTreePanel();
		westPanel.setWidth(250);
		westPanel.setBorder(false);
		borderPanel.add(westPanel,new BorderLayoutData(RegionPosition.WEST));
		
		eastPanel = new CollaborationsTreePanel();
		eastPanel.setWidth(250);
		eastPanel.setBorder(false);
		borderPanel.add(eastPanel,new BorderLayoutData(RegionPosition.EAST));
		
		final Panel centerPanel = new Panel();
		
		centerPanel.setBorder(false);
		centerPanel.setLayout(new AnchorLayout());
		
		Panel northPanel = new Panel("Authentication"); 
		northPanel.setLayout(new VerticalLayout(10));
		Panel topanel = new Panel();
		topanel.add(new Label("Login"));
		final TextField tf = new TextField("Login");
		topanel.add(tf);
		northPanel.add(topanel);
		final Label info = new Label("You are not logged in.");
		northPanel.add(info);
		centerPanel.add(northPanel, new AnchorLayoutData("100% 20%"));
		
		creationPanel = new Panel("Collaboration creation");
		centerPanel.add(creationPanel, new AnchorLayoutData("100% 40%"));
		
		final Panel joinPanel = new Panel("Join a Collaboration");
		centerPanel.add(joinPanel, new AnchorLayoutData("100% 40%"));
		
		borderPanel.add(centerPanel,new BorderLayoutData(RegionPosition.CENTER));
		
		panel.add(borderPanel);
		
		
		//LOGIN
		northPanel.add(new Button("Connect",new ButtonListenerAdapter(){
			public void onClick(Button button, EventObject e) {
				final String id = tf.getText();
				
				deltaService.connnect(id, new AsyncCallback<CollaborationStatus>() {
					public void onSuccess(CollaborationStatus arg0) {
						if(arg0!=null && CometEntryPoint.this.id==null){
							status = arg0;
							CometEntryPoint.this.id = id;
							me = status.getUserById(id);
							
							refreshTreePanels();
							
							fillCreationPanel();
							
							addJoinCollaborationFacility(joinPanel);
							
							centerPanel.doLayout();
							
							addRemoteEventListener();

							info.setText("You are logged as "+id);
						}
						else{
							MessageBox.alert("Connection failed.");
						}
					}
					
					public void onFailure(Throwable arg0) {
						MessageBox.alert(arg0.getMessage());
					}
				});
			}
		}));
		
		Window.addCloseHandler(new CloseHandler<Window>() {
			public void onClose(CloseEvent<Window> arg0) {
				//TODO remoteEventService.removeListener(clientManagemntDomain,);
				
				deltaService.disconnect(id, new AsyncCallback<Boolean>() {
					public void onFailure(Throwable arg0) {}
					public void onSuccess(Boolean arg0) {}
				});
			}
		});
		
		new Viewport(panel);
	}
	
	private void addRemoteEventListener() {
		//REMOTE EVENT SERVICE
		remoteEventService = RemoteEventServiceFactory.getInstance().getRemoteEventService();
		remoteEventService.addListener(DomainFactory.getDomain(ServiceEvent.clientManagementDomain), new RemoteEventListener() {
			public void apply(Event e) {
				if(e instanceof ServiceEvent){
					ServiceEvent me = (ServiceEvent) e;
					if(!me.getEditorID().equals(id)){
						if(e instanceof NewCollaborationEvent){
							NewCollaborationEvent nce = (NewCollaborationEvent) me;
							status.getCollaborations().add(nce.getCollaboration());
							refreshTreePanels();
						}
						else if(e instanceof UserJoinedCollaborationEvent){
							UserJoinedCollaborationEvent joinEvent = (UserJoinedCollaborationEvent) e;
							Collaboration c = status.getCollaborationByName(joinEvent.getCollaboration().getName());
							c.addParticipant(joinEvent.getUser());
							refreshTreePanels();
						}
						else if(e instanceof UserLeftCollaborationEvent){
							UserLeftCollaborationEvent leaveEvent = (UserLeftCollaborationEvent) e;
							Collaboration c = status.getCollaborationByName(leaveEvent.getCollaboration().getName());
							c.removeParticipant(leaveEvent.getUser());
							refreshTreePanels();
						}
					}
				}
			}
		});
	}
	
	private void fillCreationPanel(){
		creationPanel.add(new Label("CollaborationName"));
		final TextField tf = new TextField("Collaboration Name", "collaborationName", 230);  
		tf.setAllowBlank(false);  
		creationPanel.add(tf);  
		
		Button button = new Button();
		button.setText("Create Collaboration");
		button.addListener(new ButtonListenerAdapter(){
			public void onClick(Button button, EventObject e) {
				String text = tf.getText();
				if(text!=null && !text.equals("")){
					String message = "Are you sure you want to create a collaboration named ";
					message += tf.getText();
					message += " with "+westPanel.getSelectedUsers();
					
					MessageBox.confirm("Creation confirmation", message, new ConfirmCallback() {
						public void execute(String btnID) {
							if(btnID.equals("yes")){
								UserGroup ug = status.getUsersById(westPanel.getSelectedUsers());
								ug.addUser(me);
								
								deltaService.createCollaboration(id, tf.getText(), ug, new AsyncCallback<Collaboration>() {
									public void onFailure(Throwable arg0) {
										MessageBox.alert(arg0.getMessage());
									}
									public void onSuccess(Collaboration arg0) {
										if(arg0==null){
											MessageBox.alert("A collaboration named "+tf.getText()+" already exists. Please choose another name");
										}
										else{
											status.getCollaborations().add(arg0);
											refreshTreePanels();
										}
									}
								});
							}
						}
					});
					
				}
			}
		});
		creationPanel.add(button);
		
	}
	
	
	private void addJoinCollaborationFacility(Panel p){
		Button button = new Button();
		button.setText("Join Collaboration");
		button.addListener(new ButtonListenerAdapter(){
			public void onClick(Button button, EventObject e) {
				List<String> l = eastPanel.getSelectedCollaborations();
				if(l.size()!=1){
					MessageBox.alert("Choose exactly 1 collaboration.");
				}
				else{
					Collaboration collab = status.getCollaborationByName(l.get(0));
					
					if(collab.isInvited(me)){
						//TODO remove try catch
						try{
							new CometStandAloneBPMNEditor(me, collab).onModuleLoad();
						}
						catch(Exception ex){
							MessageBox.alert(ex.getMessage());
							ex.printStackTrace(System.out);
						}
					}
					else{
						MessageBox.alert("You are not part of this collaboration : "+collab.getName());
					}
				}
			}
		});
		
		p.add(button);
	}
	
	
	private void refreshTreePanels(){
		westPanel.displayUsers(status.getUsers());
		westPanel.doLayout();
		
		eastPanel.displayCollaborations(status.getCollaborations());
		eastPanel.doLayout();
	}
	

}
