/**
 * BPMN Editor Collaborative client - A collaboration platform client for the BPMN Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.collaboration.comet.client.service;

import java.util.ArrayList;

import com.ebmwebsourcing.bpmneditor.collaboration.comet.client.to.CollaborationStatus;
import com.ebmwebsourcing.bpmneditor.collaboration.comet.client.to.cometLogEntry.CometLogEntry;
import com.ebmwebsourcing.bpmneditor.collaboration.comet.client.user.Collaboration;
import com.ebmwebsourcing.bpmneditor.collaboration.comet.client.user.User;
import com.ebmwebsourcing.bpmneditor.collaboration.comet.client.user.UserGroup;
import com.ebmwebsourcing.bpmneditor.presentation.gwt.client.bpmneditor.bpmn2.renderer.DefinitionsSyntaxModel;
import com.google.gwt.user.client.rpc.AsyncCallback;


public interface DeltaServiceAsync {
	
	public void connnect(String editorID, AsyncCallback<CollaborationStatus> callback);
	
	public void disconnect(String editorID, AsyncCallback<Boolean> callback);
	
	public void createCollaboration(String editorId, String collaborationName, UserGroup coworkers, AsyncCallback<Collaboration> callback);

	
	
	
	public void joinCollaboration(User user, String name, AsyncCallback<Void> callback);
	
	public void pushCurrentState(User master, ArrayList<DefinitionsSyntaxModel> state, AsyncCallback<Void> callback);
	
	public void leaveCollaboration(User user, AsyncCallback<Void> callback);
	
	public void submitModification(User user, CometLogEntry entry, AsyncCallback<Void> callback);
	
	public void changeDrawingPanel(User user, String defsId, AsyncCallback<Void> callback);
	
	public void closeDrawingPanel(User user, String defsId, AsyncCallback<Void> callback);
	
	public void newDrawingPanel(User user, DefinitionsSyntaxModel defs, AsyncCallback<Void> callback);
	
	public void lock(User user, AsyncCallback<Boolean> callback);
	
	public void unlock(User user, AsyncCallback<Boolean> callback);
}
