/**
 * BPMN Editor Collaborative client - A collaboration platform client for the BPMN Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.collaboration.comet.client.to.cometLogEntry;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.foundation.GraphicElementBean;

public class PropertyChangedCometLogEntry extends CometLogEntry {

	private GraphicElementBean bean;
	
	public PropertyChangedCometLogEntry(){super();}
	
	public PropertyChangedCometLogEntry(String diagramElementId, String modelId, GraphicElementBean bean){
		super(diagramElementId,modelId);
		this.bean = bean;
	}

	
	@Override
	public boolean isSimilar(CometLogEntry other) {
		if(other instanceof AddElementCometLogEntry && checkIds(other)){
			PropertyChangedCometLogEntry e = (PropertyChangedCometLogEntry) other;
			
			return bean.getId().equals(e.bean.getId());
			//TODO maybe complete
		}
		return false;
	}

	public GraphicElementBean getBean() {
		return bean;
	}

	public void setBean(GraphicElementBean bean) {
		this.bean = bean;
	}
	
	
}
